package com.patzn.lims.excel.handler;

import com.patzn.lims.excel.eto.LmsStaffTrainETO;
import com.patzn.poibox.excel.AbstractExeclExportHandler;
import com.patzn.poibox.excel.IExcelTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 不确定度评定报告导出
 */
public class LmsStaffTrainRecordPersonExportHandler extends AbstractExeclExportHandler {

    private List<LmsStaffTrainETO> itemList = null;

    public LmsStaffTrainRecordPersonExportHandler(List<LmsStaffTrainETO> itemList) {
        this.itemList = itemList;
    }

    @Override
    public IExcelTemplate exportTemplate() {
        return new IExcelTemplate() {
            @Override
            public String tplname() {
                return "LmsStaffTrainRecordPersonTpl";
            }

            @Override
            public String outname() {
                return "培训记录人员导出";
            }
        };
    }

    @Override
    protected Map<String, Object> renderData() {
        Map<String, Object> objMap = new HashMap<>(1);
        objMap.put("itemList", itemList);
        return objMap;
    }
}
