package com.patzn.lims.file.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.file.entity.LmsFile;
import com.patzn.lims.file.service.ILmsFileService;
import com.patzn.lims.file.vo.LmsFileVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 高校文件 前端控制器
 * </p>
 *
 * @author wangweidong
 * @since 2019-12-13
 */
@Api(description = "高校文件")
@RestController
@RequestMapping("/v1/file")
public class LmsFileController extends ServiceController<ILmsFileService, LmsFile> {



    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsFile>> getPage(LmsFile schoolFile) {
        return success(baseService.page(getPage(), schoolFile));
	}


    @ApiOperation(value = "文件分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_vo")
    public PtResult<IPage<LmsFileVO>> getPageVO(LmsFileVO schoolFile) {
        return success(baseService.pageVO(getPage(), schoolFile));
    }



    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsFile>> getList(LmsFile schoolFile) {
        return success(baseService.list(schoolFile));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsFile> get(@PathVariable("id") Long id) {
        return success(baseService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsFile schoolFile) {
        schoolFile.setId(id);
        return success(baseService.updateById(schoolFile));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
	public PtResult<Boolean> add(LmsFile schoolFile) {
        return success(baseService.save(schoolFile));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(baseService.remove(Wrappers.<LmsFile>query().in("id", ids)));
	}

    @PostMapping(value = "/upload")
    public  PtResult<Boolean> uploadFile(@RequestParam("folderId") String folderId, @RequestParam("file") MultipartFile file)  {
       return success(baseService.saveFile(folderId,file,getAccount()));
    }

    @ApiOperation(value = "下载文件", notes = "批量下载文件")
    @GetMapping(value = "/down_load/{id}")
    public  void downLoad(@PathVariable("id") Long id)  {
        baseService.downLoad(id,request,response);
    }

    @ApiOperation(value = "批量下载文件", notes = "批量下载文件")
    @GetMapping("/download_batch")
    public void downloadBatch(@RequestParam("folderId") Long folderId) {
        baseService.downloadBatch(folderId, response);
    }

    @ApiOperation(value = "批量下载文件", notes = "批量下载文件")
    @GetMapping("/download_by_ids")
    public void downloadBatchByIds(@RequestParam("ids") Long[] ids) {
        baseService.downloadByIds(ids, response);
    }

}
