package com.patzn.lims.file.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.file.entity.LmsFileStorage;
import com.patzn.lims.file.service.ILmsFileStorageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 文件存储 前端控制器
 * </p>
 *
 * @author wangweidong
 * @since 2019-12-13
 */
@Api(description = "文件存储")
@RestController
@RequestMapping("/v1/file_storage")
public class LmsFileStorageController extends ServiceController<ILmsFileStorageService, LmsFileStorage> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsFileStorage>> getPage(LmsFileStorage schoolFileStorage) {
        return success(baseService.page(getPage(), schoolFileStorage));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsFileStorage>> getList(LmsFileStorage schoolFileStorage) {
        return success(baseService.list(schoolFileStorage));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsFileStorage> get(@PathVariable("id") Long id) {
        return success(baseService.getById(id));
    }


    @GetMapping("/vo/")
    public PtResult<LmsFileStorage> getVO() {
        return success(baseService.getVOByCompanyId(currentCompanyId()));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsFileStorage schoolFileStorage) {
        schoolFileStorage.setId(id);
        return success(baseService.updateById(schoolFileStorage));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
	public PtResult<Boolean> add(LmsFileStorage schoolFileStorage) {
        return success(baseService.save(schoolFileStorage));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(baseService.remove(Wrappers.<LmsFileStorage>query().in("id", ids)));
	}

}
