package com.patzn.lims.file.entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author wangweidong
 * @since 2019-12-13
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsFileStorage extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "存储名称")
	private String name;

    @ApiModelProperty(value = "桶名称")
	private String bucket;

    @ApiModelProperty(value = "最大容量MB")
	private BigDecimal capacity;

    @ApiModelProperty(value = "最大容量KB")
	private BigDecimal capacityKb;

    @ApiModelProperty(value = "已使用容量")
	private BigDecimal used;
	private BigDecimal leftover;

    @ApiModelProperty(value = "企业ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "0")
    @TableLogic
	private Integer deleted;
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

	private  Integer version;




}
