package com.patzn.lims.file.service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.file.entity.LmsFile;
import com.patzn.lims.file.vo.LmsFileVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author wangweidong
 * @since 2019-12-13
 */
public interface ILmsFileService extends IBaseService<LmsFile> {


    Page<LmsFile> page(Page<LmsFile> page, LmsFile schoolFile);


    List<LmsFile> list(LmsFile schoolFile);

    Page<LmsFileVO> pageVO(Page<LmsFileVO> page, LmsFileVO schoolFile);

    boolean saveFile(String folderId, MultipartFile file, Account account);

    void downLoad(Long id, HttpServletRequest request, HttpServletResponse response);

    void downloadBatch(Long folderId, HttpServletResponse response);

    void downloadByIds(Long[] ids, HttpServletResponse response);
}
