package com.patzn.lims.frame.controller;

import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsAbilityMainPlanAttachment;
import com.patzn.lims.frame.service.ILmsAbilityMainPlanAttachmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 能力验证计划主表附件表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-07-19
 */
@Api(description = "能力验证计划主表附件表")
@RestController
@RequestMapping("/v1/ability_main_plan_attachment")
public class LmsAbilityMainPlanAttachmentController extends ServiceController<ILmsAbilityMainPlanAttachmentService, LmsAbilityMainPlanAttachment> {

    @Autowired
    private ILmsAbilityMainPlanAttachmentService lmsAbilityMainPlanAttachmentService;


    @ApiOperation(value = "下载附件", notes = "下载指定附件")
    @GetMapping("/download/{id}")
    public void downloadFile(@PathVariable("id")Long id) {
        lmsAbilityMainPlanAttachmentService.downloadFile(id, response);
    }


}
