package com.patzn.lims.frame.controller;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsAbilityMainPlan;
import com.patzn.lims.frame.entity.LmsAbilityMainPlanAttachment;
import com.patzn.lims.frame.enums.PlanStatusEnum;
import com.patzn.lims.frame.service.ILmsAbilityMainPlanService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 能力验证计划主表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-07-19
 */
@Api(description = "能力验证计划主表")
@RestController
@RequestMapping("/v1/ability_main_plan")
public class LmsAbilityMainPlanController extends ServiceController<ILmsAbilityMainPlanService,LmsAbilityMainPlan> {

    @Autowired
    private ILmsAbilityMainPlanService lmsAbilityMainPlanService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<IPage<LmsAbilityMainPlan>> getPage(LmsAbilityMainPlan lmsAbilityMainPlan) {
        lmsAbilityMainPlan.setTempStatus(1);
        return success(lmsAbilityMainPlanService.page(getPage(), lmsAbilityMainPlan));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsAbilityMainPlan>> getList(LmsAbilityMainPlan lmsAbilityMainPlan) {
        return success(lmsAbilityMainPlanService.list(lmsAbilityMainPlan));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    @Override
    public PtResult<LmsAbilityMainPlan> get(@PathVariable("id") Long id) {
        return success(lmsAbilityMainPlanService.getVOById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsAbilityMainPlan lmsAbilityMainPlan) {
        lmsAbilityMainPlan.setId(id);
        return success(lmsAbilityMainPlanService.updatePlanById(lmsAbilityMainPlan));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(LmsAbilityMainPlan lmsAbilityMainPlan) {
        lmsAbilityMainPlan.setMakerId(getAccount().getUserId());
        lmsAbilityMainPlan.setMaker(getAccount().getUserName());
        lmsAbilityMainPlan.setMakeDate(new Date());
        lmsAbilityMainPlan.setStatus((Integer) PlanStatusEnum.DRAFT.getValue());
        lmsAbilityMainPlan.setProgress((Integer)PlanStatusEnum.DRAFT.getValue());
        lmsAbilityMainPlan.setTempStatus(1);
        return success(lmsAbilityMainPlanService.add(lmsAbilityMainPlan));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsAbilityMainPlanService.removeByIds(ids));
    }


    @ApiOperation(value = "能力计划主表分页列表", notes = "能力计划主表分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_plan")
    public PtResult<IPage<LmsAbilityMainPlan>> getPagePlan(LmsAbilityMainPlan lmsAbilityMainPlan, Date startDate, Date endDate) {
        lmsAbilityMainPlan.setTempStatus(1);
        return success(lmsAbilityMainPlanService.pagePlan(getPage(), lmsAbilityMainPlan, startDate, endDate));
    }


    @ApiOperation(value = "能力记录主表分页列表", notes = "能力记录主表分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_record")
    public PtResult<IPage<LmsAbilityMainPlan>> getPageRecord(LmsAbilityMainPlan lmsAbilityMainPlan, Date startDate, Date endDate) {
        lmsAbilityMainPlan.setStatus((Integer)PlanStatusEnum.PASS.getValue());
        return success(lmsAbilityMainPlanService.pagePlan(getPage(), lmsAbilityMainPlan, startDate, endDate));
    }


    @ApiOperation(value = "复制能力验证主计划", notes = "复制能力验证主计划")
    @PostMapping("/copy")
    public PtResult<Boolean> copy(LmsAbilityMainPlan lmsAbilityMainPlan) {
        return success(lmsAbilityMainPlanService.copy(lmsAbilityMainPlan, getAccount()));
    }


    @ApiOperation(value = "能力计划提交至审批", notes = "能力计划提交至审批")
    @PostMapping("/submit_flow")
    public PtResult<Boolean> submit(@RequestParam("ids") Long[] ids) {
        return success(null != lmsAbilityMainPlanService.submitCheckFlow(ids, getAccount()));
    }


    @ApiOperation(value = "能力计划审批(pass or back)", notes = "能力计划审批(pass or back)")
    @PostMapping("/approve/{taskId}")
    public PtResult<Boolean> approve(@PathVariable("taskId") String taskId, String status, String reason) {
        return success(lmsAbilityMainPlanService.approveFlow(taskId, status, reason));
    }


    @ApiOperation(value = "导出能力验证计划", notes = "导出能力验证计划")
    @PostMapping("/export_plan")
    public void exportPlan(@RequestParam("id") Long id) {
        PtAssert.fail(null == id, "请选择导出计划");
        lmsAbilityMainPlanService.exportPlan(response, id);
    }


    @GetMapping("/getTemp/")
    public PtResult<LmsAbilityMainPlan> getTemp() {
        return success(lmsAbilityMainPlanService.getTempVO());
    }


    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsAbilityMainPlanAttachment> uploadFile(@RequestParam("file") MultipartFile file, LmsAbilityMainPlan lmsAbilityMainPlan) {
        return success(lmsAbilityMainPlanService.uploadFile(file, lmsAbilityMainPlan));
    }

    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile/")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id) {
        return success(lmsAbilityMainPlanService.deleteFile(id));
    }

}
