package com.patzn.lims.frame.controller;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.patzn.lims.common.DateUtils;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsAbilitySubPlan;
import com.patzn.lims.frame.enums.PlanStatusEnum;
import com.patzn.lims.frame.service.ILmsAbilitySubPlanService;
import com.patzn.lims.res.dto.LmsAbilitySubPlanDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 能力验证计划子表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-07-19
 */
@Api(description = "能力验证计划子表")
@RestController
@RequestMapping("/v1/ability_sub_plan")
public class LmsAbilitySubPlanController extends ServiceController<ILmsAbilitySubPlanService, LmsAbilitySubPlan> {

    @Autowired
    private ILmsAbilitySubPlanService lmsAbilitySubPlanService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<IPage<LmsAbilitySubPlan>> getPage(LmsAbilitySubPlan lmsAbilitySubPlan) {
        return success(lmsAbilitySubPlanService.page(getPage(), lmsAbilitySubPlan));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsAbilitySubPlan>> getList(LmsAbilitySubPlan lmsAbilitySubPlan) {
        return success(lmsAbilitySubPlanService.list(lmsAbilitySubPlan));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    @Override
    public PtResult<LmsAbilitySubPlan> get(@PathVariable("id") Long id) {
        return success(lmsAbilitySubPlanService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsAbilitySubPlan lmsAbilitySubPlan) {
        lmsAbilitySubPlan.setId(id);
        return success(lmsAbilitySubPlanService.updatePlanById(lmsAbilitySubPlan));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
    public PtResult<Boolean> add(LmsAbilitySubPlan lmsAbilitySubPlan) {
        PtAssert.fail(null == lmsAbilitySubPlan || null == lmsAbilitySubPlan.getMainPlanId(), "请确认主计划");
        lmsAbilitySubPlan.setUname(getAccount().getUserName());
        lmsAbilitySubPlan.setStatus((Integer)PlanStatusEnum.DRAFT.getValue());
        lmsAbilitySubPlan.setProgress((Integer) PlanStatusEnum.DRAFT.getValue());
        return success(lmsAbilitySubPlanService.save(lmsAbilitySubPlan));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsAbilitySubPlanService.removeByIds(ids));
    }


    @ApiOperation(value = "能力计划子表分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_sub_plan")
    public PtResult<IPage<LmsAbilitySubPlan>> getPageSubPlan(LmsAbilitySubPlan lmsAbilitySubPlan, Date startDate, Date endDate) {
        return success(lmsAbilitySubPlanService.pageSubPlan(getPage(), lmsAbilitySubPlan, startDate, endDate));
    }


    @ApiOperation(value = "复制", notes = "复制一条数据")
    @PostMapping("/copy")
    public PtResult<Boolean> copy(LmsAbilitySubPlan lmsAbilitySubPlan) {
        return success(lmsAbilitySubPlanService.copy(lmsAbilitySubPlan, getAccount()));
    }


    @ApiOperation(value = "提交", notes = "提交")
    @PostMapping("/submit")
    public PtResult<Boolean> submit(@RequestParam("ids") Long[] ids,
                                      @RequestParam("result") String result,
                                      @RequestParam("person") String person,
                                      @RequestParam("endDate") Date endDate) {
        return success(lmsAbilitySubPlanService.submit(ids, result, person, endDate));
    }

    @ApiOperation(value = "导出数据", notes = "导出数据")
    @PostMapping("/export")
    public void exportExcel(@RequestParam("ids") List<Long> ids) {
        List<LmsAbilitySubPlanDTO> dtoList = Lists.newArrayList();
        List<LmsAbilitySubPlan> list = lmsAbilitySubPlanService.list(Wrappers.<LmsAbilitySubPlan>query().in("id", ids));
        for (LmsAbilitySubPlan entity : list) {
            LmsAbilitySubPlanDTO dto = entity.convert(LmsAbilitySubPlanDTO.class);
            if (dto.getCompletion() != null) {
                dto.setCompleteTime(DateUtils.toYearMonthDay(dto.getCompletion()));
            }
            dtoList.add(dto);
        }
//        new LmsAbilitySubPlanExportHandler(dtoList).generater(response);
    }


}
