package com.patzn.lims.frame.controller;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Lists;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsFrameCheckManage;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.service.ILmsFrameCheckManageService;
import com.patzn.lims.frame.vo.LmsFrameCheckManageVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 管理评审计划管理 前端控制器
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Api(description = "管理评审计划管理")
@RestController
@RequestMapping("/v1/frame_check_manage")
public class LmsFrameCheckManageController extends ServiceController<ILmsFrameCheckManageService,LmsFrameCheckManage> {

    @Autowired
    private ILmsFrameCheckManageService lmsFrameCheckManageService;

    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<IPage<LmsFrameCheckManage>> getPage(LmsFrameCheckManage lmsFrameCheckManage) {
        return success(lmsFrameCheckManageService.page(getPage(), lmsFrameCheckManage));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")

    public PtResult<List<LmsFrameCheckManage>> getList(LmsFrameCheckManage lmsFrameCheckManage) {
        return success(lmsFrameCheckManageService.list(lmsFrameCheckManage));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")

    public PtResult<LmsFrameCheckManageVO> getVO(@PathVariable("id") Long id) {
        return success(lmsFrameCheckManageService.getVOById(id));
    }


    @ApiOperation(value = "查询临时数据", notes = "查询临时数据")
    @GetMapping("/getTemp/")
    public PtResult<LmsFrameCheckManageVO> getTemp() {
        return success(lmsFrameCheckManageService.getTempVO());
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")

    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsFrameCheckManage lmsFrameCheckManage) {
        return success(lmsFrameCheckManageService.edit(lmsFrameCheckManage));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")

    public PtResult<Boolean> add(LmsFrameCheckManage lmsFrameCheckManage) {
        return success(lmsFrameCheckManageService.add(lmsFrameCheckManage));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")

    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameCheckManageService.delete(ids));
    }


    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsFrameFile> uploadFile(@RequestParam("file") MultipartFile file, LmsFrameCheckManage lmsFrameCheckManage) {
        return success(lmsFrameCheckManageService.uploadFile(file, lmsFrameCheckManage));
    }

    @ApiOperation(value = "下载附件", notes = "下载指定产品的产品附件")
    @GetMapping("/downLoadFile")
    public void downloadFile(Long id) {
        lmsFrameCheckManageService.downloadFile(id, response);
    }


    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile/")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id) {
        return success(lmsFrameCheckManageService.deleteFile(id));
    }


    @PostMapping("/submit/")
    public PtResult<Boolean> submit(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameCheckManageService.submit(Arrays.asList(ids)));
    }


    @ApiOperation(value = "导出数据", notes = "导出数据")
    @GetMapping("/export")
    public void exportExcel(@RequestParam("ids") List<Long> ids, @RequestParam("checkPlanId") Long checkPlanId) {
//        List<LmsFrameCheckManageDto> dtoList = Lists.newArrayList();
//        List<LmsFrameCheckManage> list = lmsFrameCheckManageService.list(Wrappers.query().in("id", ids).eq("check_plan_id",checkPlanId));
//        for (LmsFrameCheckManage entity : list) {
//            LmsFrameCheckManageDto dto = getDto(entity);
//            dtoList.add(dto);
//        }
//        new LmsFrameCheckManageExportHandler(dtoList).generater(response);
    }

//    private LmsFrameCheckManageDto getDto(LmsFrameCheckManage entity) {
//        LmsFrameCheckManageDto dto = new LmsFrameCheckManageDto();
//        dto.setRegisterName(entity.getRegisterName());
//        if (null != entity.getCheckManageTime()) {
//            dto.setCheckManageTimeStr(sdf.format(entity.getCheckManageTime()));
//        }
//        if (null != entity.getCtime()) {
//            dto.setCtime(sdf.format(entity.getCtime()));
//        }
//        dto.setCheckManageContent(entity.getCheckManageContent());
//        dto.setCheckManageResult(entity.getCheckManageResult());
//        dto.setRemark(entity.getRemark());
//        if (null != entity.getUname()) {
//            dto.setUname(entity.getUname());
//        }
//        return dto;
//    }


}
