package com.patzn.lims.frame.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsFrameCheckPlan;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.service.ILmsFrameCheckPlanService;
import com.patzn.lims.frame.vo.LmsFrameCheckPlanVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.text.SimpleDateFormat;
import java.util.List;

/**
 * <p>
 * 管理评审计划 前端控制器
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Api(description = "管理评审计划")
@RestController
@RequestMapping("/v1/frame_check_plan")
public class LmsFrameCheckPlanController extends ServiceController<ILmsFrameCheckPlanService,LmsFrameCheckPlan> {

    @Autowired
    private ILmsFrameCheckPlanService lmsFrameCheckPlanService;

    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")

    public PtResult<Page<LmsFrameCheckPlan>> getPage(LmsFrameCheckPlan lmsFrameCheckPlan) {
        return success(lmsFrameCheckPlanService.page(getPage(), lmsFrameCheckPlan));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")

    public PtResult<List<LmsFrameCheckPlan>> getList(LmsFrameCheckPlan lmsFrameCheckPlan) {
        return success(lmsFrameCheckPlanService.list(lmsFrameCheckPlan));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")

    public PtResult<LmsFrameCheckPlanVO> getVO(@PathVariable("id") Long id) {
        return success(lmsFrameCheckPlanService.getVOById(id));
    }


    @GetMapping("/getTemp/")
    public PtResult<LmsFrameCheckPlanVO> getTemp() {
        return success(lmsFrameCheckPlanService.getTempVO());
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")

    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsFrameCheckPlan lmsFrameCheckPlan) {
        return success(lmsFrameCheckPlanService.edit(lmsFrameCheckPlan));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")

    public PtResult<Boolean> add(LmsFrameCheckPlan lmsFrameCheckPlan) {
        return success(lmsFrameCheckPlanService.add(lmsFrameCheckPlan));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")

    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameCheckPlanService.delete(ids));
    }


    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsFrameFile> uploadFile(@RequestParam("file") MultipartFile file, LmsFrameCheckPlan lmsFrameCheckPlan) {
        return success(lmsFrameCheckPlanService.uploadFile(file, lmsFrameCheckPlan));
    }

    @ApiOperation(value = "下载附件", notes = "下载指定附件")
    @GetMapping("/downLoadFile")
    public void downloadFile(Long id) {
        lmsFrameCheckPlanService.downloadFile(id, response);
    }


    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile/")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id) {
        return success(lmsFrameCheckPlanService.deleteFile(id));
    }

    @PostMapping("/submit/")
    public PtResult<Boolean> submit(@RequestParam("ids") Long[] ids) {
        return success(null != lmsFrameCheckPlanService.submitCheckFlow(ids, getAccount()));
    }


    @PostMapping("/approve/{taskId}")
    public PtResult<Boolean> approve(@PathVariable("taskId") String taskId, String status, String reason) {
        return success(lmsFrameCheckPlanService.approveFlow(taskId, status, reason));
    }


    @ApiOperation(value = "导出数据", notes = "导出数据")
    @GetMapping("/export")
    public void exportExcel(@RequestParam("ids") List<Long> ids) {
//        List<LmsFrameCheckPlanDto> dtoList = Lists.newArrayList();
//        List<LmsFrameCheckPlan> list = lmsFrameCheckPlanService.list(Wrappers.query().in("id", ids).eq("temp_status", 1));
//        for (LmsFrameCheckPlan entity : list) {
//            LmsFrameCheckPlanDto dto = getDto(entity);
//            dtoList.add(dto);
//        }
//        new LmsFrameCheckPlanExportHandler(dtoList).generater(response);
    }


//    private LmsFrameCheckPlanDto getDto(LmsFrameCheckPlan entity) {
//        LmsFrameCheckPlanDto dto = new LmsFrameCheckPlanDto();
//        dto.setCheckPlanPurpose(entity.getCheckPlanPurpose());
//
//        if (null != entity.getCheckPlanTime()) {
//            dto.setCheckPlanTimeStr(DateUtils.toYearMonthDay(entity.getCheckPlanTime()));
//        }
//
//        dto.setCheckPlanBasis(entity.getCheckPlanBasis());
//        dto.setCheckGroupLeaderName(entity.getCheckGroupLeaderName());
//        dto.setCheckGroupMemberNames(entity.getCheckGroupMemberNames());
//        if (null != entity.getCheckPlanContent()) {
//            dto.setCheckPlanContent(entity.getCheckPlanContent().replaceAll("<[.[^<]]*>", ""));
//        }
//        dto.setApplyName(entity.getApplyName());
//        if (null != entity.getApplyTime()) {
//            dto.setApplyTimeStr(DateUtils.toYearMonthDay(entity.getApplyTime()));
//        }
//        dto.setAuditName(entity.getAuditName());
//        if (null != entity.getAuditTime()) {
//            dto.setApplyTimeStr(DateUtils.toYearMonthDay(entity.getAuditTime()));
//        }
//        dto.setRemark(entity.getRemark());
//        if (null != entity.getStatus()) {
//            dto.setStatus(entity.getStatus().getDisplay());
//        }
//        if (null != entity.getCheckPlanPlace()) {
//            dto.setCheckPlanPlace(entity.getCheckPlanPlace());
//        }
//        return dto;
//    }

}
