package com.patzn.lims.frame.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsFrameCheckReport;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.service.ILmsFrameCheckReportService;
import com.patzn.lims.frame.vo.LmsFrameCheckReportVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 管理评审报告表 前端控制器
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Api(description = "管理评审报告表")
@RestController
@RequestMapping("/v1/frame_check_report")
public class LmsFrameCheckReportController extends ServiceController <ILmsFrameCheckReportService,LmsFrameCheckReport> {

    @Autowired
    private ILmsFrameCheckReportService lmsFrameCheckReportService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")

	public PtResult<Page<LmsFrameCheckReport>> getPage(LmsFrameCheckReport lmsFrameCheckReport) {
        return success(lmsFrameCheckReportService.page(getPage(), lmsFrameCheckReport));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")

    public PtResult<List<LmsFrameCheckReport>> getList(LmsFrameCheckReport lmsFrameCheckReport) {
        return success(lmsFrameCheckReportService.list(lmsFrameCheckReport));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")

    public PtResult<LmsFrameCheckReportVO> getVO(@PathVariable("id") Long id) {
        return success(lmsFrameCheckReportService.getVOById(id));
    }


    @ApiOperation(value = "查询临时数据", notes = "查询临时数据")
    @GetMapping("/getTemp/")
    public PtResult<LmsFrameCheckReportVO> getTemp() {
        return success(lmsFrameCheckReportService.getTempVO());
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")

	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsFrameCheckReport lmsFrameCheckReport) {
        return success(lmsFrameCheckReportService.edit(lmsFrameCheckReport));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")

	public PtResult<Boolean> add(LmsFrameCheckReport lmsFrameCheckReport) {
        return success(lmsFrameCheckReportService.add(lmsFrameCheckReport));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")

	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameCheckReportService.delete(ids));
	}


    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsFrameFile> uploadFile(@RequestParam("file") MultipartFile file, LmsFrameCheckReport lmsFrameCheckReport){
        return success(lmsFrameCheckReportService.uploadFile(file, lmsFrameCheckReport));
    }

    @ApiOperation(value = "下载附件", notes = "下载指定附件")
    @GetMapping("/downLoadFile")
    public void downloadFile(Long id) {
        lmsFrameCheckReportService.downloadFile(id, response);
    }


    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile/")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id){
        return success(lmsFrameCheckReportService.deleteFile(id));
    }


    @PostMapping("/submit/")
    public PtResult<Boolean> submit(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameCheckReportService.submit(Arrays.asList(ids)));
    }


}
