package com.patzn.lims.frame.controller;


import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.dto.LmsFrameComplaintManageDTO;
import com.patzn.lims.frame.entity.LmsFrameComplaintManage;
import com.patzn.lims.frame.service.ILmsFrameComplaintManageService;
import com.patzn.lims.frame.vo.LmsFrameComplaintManageVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 投/申诉登记管理 前端控制器
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Api(description = "投/申诉登记管理")
@RestController
@RequestMapping("/v1/frame_complaint_manage")
public class LmsFrameComplaintManageController extends ServiceController<ILmsFrameComplaintManageService,LmsFrameComplaintManage>  {

    @Autowired
    private ILmsFrameComplaintManageService lmsFrameComplaintManageService;

    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")

	public PtResult<Page<LmsFrameComplaintManageVO>> getPage(LmsFrameComplaintManageDTO lmsFrameComplaintManageDTO) {
        return success(lmsFrameComplaintManageService.pageVO(getPage(), lmsFrameComplaintManageDTO));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")

    public PtResult<List<LmsFrameComplaintManage>> getList(LmsFrameComplaintManage lmsFrameComplaintManage) {
        return success(lmsFrameComplaintManageService.list(lmsFrameComplaintManage));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")

    public PtResult<LmsFrameComplaintManageVO> getVO(@PathVariable("id") Long id) {
        return success(lmsFrameComplaintManageService.getVOById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")

	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsFrameComplaintManage lmsFrameComplaintManage) {
        return success(lmsFrameComplaintManageService.edit(lmsFrameComplaintManage));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")

	public PtResult<Boolean> add(LmsFrameComplaintManage lmsFrameComplaintManage) {
        return success(lmsFrameComplaintManageService.save(lmsFrameComplaintManage));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")

	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameComplaintManageService.remove(Wrappers.<LmsFrameComplaintManage>query().in("id", ids)));
	}


    @PostMapping("/submit/")
    public PtResult<Boolean> submit(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameComplaintManageService.submit(Arrays.asList(ids)));
    }


    @ApiOperation(value = "导出数据", notes = "导出数据")
    @GetMapping("/export")
    public void exportExcel(@RequestParam("ids") List<Long> ids) {
//        List<LmsFrameComplaintManageDto> dtoList = Lists.newArrayList();
//        List<LmsFrameComplaintManage> list = lmsFrameComplaintManageService.list(Wrappers.query().in("id", ids));
//        for (LmsFrameComplaintManage entity: list) {
//            LmsFrameComplaintManageDto dto = getDto(entity);
//            dtoList.add(dto);
//        }
//
//        new LmsFrameComplaintManageExportHandler(dtoList).generater(response);
    }


//    private LmsFrameComplaintManageDto getDto(LmsFrameComplaintManage entity) {
//        LmsFrameComplaintManageDto dto = new LmsFrameComplaintManageDto();
//        dto.setComplaintManageAdvice(entity.getComplaintManageAdvice());
//        dto.setComplaintManageName(entity.getComplaintManageName());
//        if (null != entity.getComplaintManageTime()) {
//            dto.setComplaintManageTimeStr(sdf.format(entity.getComplaintManageTime()));
//        }
//
//        dto.setRemark(entity.getRemark());
//
//        return dto;
//    }

}
