package com.patzn.lims.frame.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.cloud.commons.toolkit.DateUtils;
import com.patzn.lims.frame.dto.LmsFrameComplaintRegisterDTO;
import com.patzn.lims.frame.entity.LmsFrameComplaintRegister;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.service.ILmsFrameComplaintRegisterService;
import com.patzn.lims.frame.vo.LmsFrameComplaintRegisterVO;
import com.patzn.lims.res.service.ILmsBaseDictService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.text.SimpleDateFormat;
import java.util.List;

/**
 * <p>
 * 投/申诉登记 前端控制器
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Api(description = "投/申诉登记")
@RestController
@RequestMapping("/v1/frame_complaint_register")
public class LmsFrameComplaintRegisterController extends ServiceController <ILmsFrameComplaintRegisterService,LmsFrameComplaintRegister> {

    @Autowired
    private ILmsFrameComplaintRegisterService lmsFrameComplaintRegisterService;
    @Autowired
    private ILmsBaseDictService lmsBaseDictService;

    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")

    public PtResult<Page<LmsFrameComplaintRegister>> getPage(LmsFrameComplaintRegisterDTO lmsFrameComplaintRegisterDTO) {
        lmsFrameComplaintRegisterDTO.setTempStatus(1);
        return success(lmsFrameComplaintRegisterService.page(getPage(), lmsFrameComplaintRegisterDTO));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")

    public PtResult<List<LmsFrameComplaintRegister>> getList(LmsFrameComplaintRegister lmsFrameComplaintRegister) {
        return success(lmsFrameComplaintRegisterService.list(lmsFrameComplaintRegister));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")

    public PtResult<LmsFrameComplaintRegisterVO> getVO(@PathVariable("id") Long id) {
        return success(lmsFrameComplaintRegisterService.getVOById(id));
    }


    @GetMapping("/getTemp/")
    public PtResult<LmsFrameComplaintRegisterVO> getTemp() {
        return success(lmsFrameComplaintRegisterService.getTempVO());
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")

    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsFrameComplaintRegister lmsFrameComplaintRegister) {
        return success(lmsFrameComplaintRegisterService.edit(lmsFrameComplaintRegister));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")

    public PtResult<Boolean> add(LmsFrameComplaintRegister lmsFrameComplaintRegister) {
        return success(lmsFrameComplaintRegisterService.add(lmsFrameComplaintRegister));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")

    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameComplaintRegisterService.delete(ids));
    }


    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsFrameFile> uploadFile(@RequestParam("file") MultipartFile file, LmsFrameComplaintRegister lmsFrameComplaintRegister) {
        return success(lmsFrameComplaintRegisterService.uploadFile(file, lmsFrameComplaintRegister));
    }

    @ApiOperation(value = "下载附件", notes = "下载指定附件")
    @GetMapping("/downLoadFile")
    public void downloadFile(Long id) {
        lmsFrameComplaintRegisterService.downloadFile(id, response);
    }

    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile/")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id) {
        return success(lmsFrameComplaintRegisterService.deleteFile(id));
    }


    @PostMapping("/submit/")
    public PtResult<Boolean> submit(@RequestParam("ids") Long[] ids) {
        return success(null != lmsFrameComplaintRegisterService.submitCheckFlow(ids, getAccount()));
    }

    @PostMapping("/approve/{taskId}")
    public PtResult<Boolean> approve(@PathVariable("taskId") String taskId, String status, String reason) {
        return success(lmsFrameComplaintRegisterService.approveFlow(taskId, status, reason));
    }






    @ApiOperation(value = "导出数据", notes = "导出数据")
    @GetMapping("/export")
    public void exportExcel(@RequestParam("ids") List<Long> ids) {
//        List<LmsFrameComplaintRegisterDto> dtoList = Lists.newArrayList();
//        List<LmsFrameComplaintRegister> list = lmsFrameComplaintRegisterService.list(Wrappers.query().in("id", ids).eq("temp_status", 1));
//        for (LmsFrameComplaintRegister entity : list) {
//            LmsFrameComplaintRegisterDto dto = getDto(entity);
//            dtoList.add(dto);
//        }
//        new LmsFrameComplaintRegisterExportHandler(dtoList).generater(response);
    }


//    private LmsFrameComplaintRegisterDto getDto(LmsFrameComplaintRegister entity) {
//        LmsFrameComplaintRegisterDto dto = new LmsFrameComplaintRegisterDto();
//        if (null != entity.getComplaintUnit()) {
//            dto.setComplaintUnit(entity.getComplaintUnit());
//        }
//        if (null != entity.getComplaintTime()) {
//            dto.setComplaintTimeStr(DateUtils.toYearMonthDay(entity.getComplaintTime()));
//        }
//        if (null != entity.getComplaintName()) {
//            dto.setComplaintName(entity.getComplaintName());
//        }
//        if (null != entity.getComplaintTel()) {
//            dto.setComplaintTel(entity.getComplaintTel());
//        }
//        if (null != entity.getCheckTime()) {
//            dto.setCheckTimeStr(DateUtils.toYearMonthDay(entity.getCheckTime()));
//        }
//        if (null != entity.getReportNum()) {
//            dto.setReportNum(entity.getReportNum());
//        }
//        if (null != entity.getComplaintType()) {
////            dto.setComplaintTypeStr(lmsBaseDictService.getByKey(entity.getComplaintType()).getLabel());
//            dto.setComplaintTypeStr(entity.getComplaintType());
//        }
//        if (null != entity.getComplaintContent()) {
//            /*去掉富文本自动生成的标签*/
//            dto.setComplaintContent(entity.getComplaintContent().replaceAll("<[.[^<]]*>", ""));
//        }
//        if (null != entity.getReceiverName()) {
//            dto.setReceiverName(entity.getReceiverName());
//        }
//        if (null != entity.getReceiverTime()) {
//            dto.setReceiverTimeStr(DateUtils.toYearMonthDay(entity.getReceiverTime()));
//        }
//        if (null != entity.getDealName()) {
//            dto.setDealName(entity.getDealName());
//        }
//        if (null != entity.getDealAdvice()) {
//            dto.setDealAdvice(entity.getDealAdvice());
//        }
//        if (null != entity.getDealTime()) {
//            dto.setDealTimeStr(DateUtils.toYearMonthDay(entity.getDealTime()));
//        }
//        if (null != entity.getRemark()) {
//            dto.setRemark(entity.getRemark());
//        }
//        return dto;
//    }
}
