package com.patzn.lims.frame.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.cloud.commons.toolkit.DateUtils;
import com.patzn.lims.frame.dto.LmsFrameCustomerInvestigateDTO;
import com.patzn.lims.frame.entity.LmsFrameCustomerInvestigate;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.service.ILmsFrameCustomerInvestigateService;
import com.patzn.lims.frame.vo.LmsFrameCustomerInvestigateVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 客户满意度管理 前端控制器
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Api(description = "客户满意度管理")
@RestController
@RequestMapping("/v1/frame_customer_investigate")
public class LmsFrameCustomerInvestigateController extends ServiceController<ILmsFrameCustomerInvestigateService,LmsFrameCustomerInvestigate>  {

    @Autowired
    private ILmsFrameCustomerInvestigateService lmsFrameCustomerInvestigateService;

    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")

	public PtResult<Page<LmsFrameCustomerInvestigate>> getPage(LmsFrameCustomerInvestigateDTO lmsFrameCustomerInvestigateDTO) {
        return success(lmsFrameCustomerInvestigateService.page(getPage(), lmsFrameCustomerInvestigateDTO));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")

    public PtResult<List<LmsFrameCustomerInvestigate>> getList(LmsFrameCustomerInvestigate lmsFrameCustomerInvestigate) {
        return success(lmsFrameCustomerInvestigateService.list(lmsFrameCustomerInvestigate));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")

    public PtResult<LmsFrameCustomerInvestigateVO> getVO(@PathVariable("id") Long id) {
        return success(lmsFrameCustomerInvestigateService.getVOById(id));
    }


    @GetMapping("/getTemp/")
    public PtResult<LmsFrameCustomerInvestigateVO> getTemp() {
        return success(lmsFrameCustomerInvestigateService.getTempVO());
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")

	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsFrameCustomerInvestigate lmsFrameCustomerInvestigate) {
        return success(lmsFrameCustomerInvestigateService.edit(lmsFrameCustomerInvestigate,getAccount()));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")

	public PtResult<Boolean> add(LmsFrameCustomerInvestigate lmsFrameCustomerInvestigate) {
        return success(lmsFrameCustomerInvestigateService.add(lmsFrameCustomerInvestigate));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")

	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameCustomerInvestigateService.delete(ids));
	}

    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsFrameFile> uploadFile(@RequestParam("file") MultipartFile file, LmsFrameCustomerInvestigate lmsFrameCustomerInvestigate){
        return success(lmsFrameCustomerInvestigateService.uploadFile(file, lmsFrameCustomerInvestigate));
    }

    @ApiOperation(value = "下载附件", notes = "下载指定附件")
    @GetMapping("/downLoadFile")
    public void downloadFile(Long id) {
        lmsFrameCustomerInvestigateService.downloadFile(id, response);
    }

    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile/")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id){
        return success(lmsFrameCustomerInvestigateService.deleteFile(id));
    }


    @PostMapping("/submit/")
    public PtResult<Boolean> submit(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameCustomerInvestigateService.submit(Arrays.asList(ids)));
    }

    @ApiOperation(value = "导出数据", notes = "导出数据")
    @GetMapping("/export")
    public void exportExcel(@RequestParam("ids") List<Long> ids) {
//        List<LmsFrameCustomerInvestigateDto> dtoList = Lists.newArrayList();
//        List<LmsFrameCustomerInvestigate> list = lmsFrameCustomerInvestigateService.list(Wrappers.query().in("id", ids).eq("deleted",0).eq("temp_status",1).orderBy("register_time",false));
//        for (LmsFrameCustomerInvestigate entity: list) {
//            LmsFrameCustomerInvestigateDto dto = getDto(entity);
//            dtoList.add(dto);
//        }
//
//        new LmsFrameCustomerInvestigateExportHandler(dtoList).generater(response);
    }


//    private LmsFrameCustomerInvestigateDto getDto(LmsFrameCustomerInvestigate entity) {
//        LmsFrameCustomerInvestigateDto dto = new LmsFrameCustomerInvestigateDto();
//        dto.setCustomerName(entity.getCustomerName());
//        dto.setCustomerAddress(entity.getCustomerAddress());
//        dto.setCustomerContact(entity.getCustomerContact());
//        dto.setCustomerTel(entity.getCustomerTel());
//        dto.setServiceItems(entity.getServiceItems());
//        if (null != entity.getRegisterTime()) {
//            dto.setRegisterTimeStr(DateUtils.toYearMonthDay(entity.getRegisterTime()));
//        }
//
//        dto.setCustomerResult(entity.getCustomerResultText());
//        dto.setCustomerAdvice(entity.getCustomerAdvice());
//        dto.setRemark(entity.getRemark());
//
//        return dto;
//    }

    @ApiOperation(value = "导出客户满意度表格", notes = "导出客户满意度表格")
    @PostMapping("/export_customer_satisfaction")
    public void exportCustomerSatisfaction(@RequestParam("id") Long id) {
        lmsFrameCustomerInvestigateService.exportCustomerSatisfaction(response,id);
    }

}
