package com.patzn.lims.frame.controller;


import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsFrameCustomerInvestigateDetail;
import com.patzn.lims.frame.service.ILmsFrameCustomerInvestigateDetailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 客户满意度调查项 前端控制器
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Api(description = "客户满意度调查项")
@RestController
@RequestMapping("/v1/frame_customer_investigate_detail")
public class LmsFrameCustomerInvestigateDetailController extends ServiceController<ILmsFrameCustomerInvestigateDetailService,LmsFrameCustomerInvestigateDetail> {

    @Autowired
    private ILmsFrameCustomerInvestigateDetailService lmsFrameCustomerInvestigateDetailService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")

	public PtResult<Page<LmsFrameCustomerInvestigateDetail>> getPage(LmsFrameCustomerInvestigateDetail lmsFrameCustomerInvestigateDetail) {
        return success(lmsFrameCustomerInvestigateDetailService.page(getPage(), lmsFrameCustomerInvestigateDetail));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")

    public PtResult<List<LmsFrameCustomerInvestigateDetail>> getList(LmsFrameCustomerInvestigateDetail lmsFrameCustomerInvestigateDetail) {
        return success(lmsFrameCustomerInvestigateDetailService.list(lmsFrameCustomerInvestigateDetail));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")

    public PtResult<LmsFrameCustomerInvestigateDetail> get(@PathVariable("id") Long id) {
        return success(lmsFrameCustomerInvestigateDetailService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")

	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsFrameCustomerInvestigateDetail lmsFrameCustomerInvestigateDetail) {
        return success(lmsFrameCustomerInvestigateDetailService.edit(lmsFrameCustomerInvestigateDetail));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")

	public PtResult<Boolean> add(LmsFrameCustomerInvestigateDetail lmsFrameCustomerInvestigateDetail) {
        lmsFrameCustomerInvestigateDetail.setUname(getAccount().getUserName());
        return success(lmsFrameCustomerInvestigateDetailService.save(lmsFrameCustomerInvestigateDetail));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")

	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameCustomerInvestigateDetailService.remove(Wrappers.<LmsFrameCustomerInvestigateDetail>query().in("id", ids)));
	}


    @PostMapping("/submit/")
    public PtResult<Boolean> submit(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameCustomerInvestigateDetailService.submit(Arrays.asList(ids)));
    }

    @ApiOperation(value = "导出数据", notes = "导出数据")
    @GetMapping("/export")
    public void exportExcel(@RequestParam("ids") List<Long> ids, @RequestParam("investigateId") Long investigateId) {
//        List<LmsFrameCustomerInvestigateDetailDto> dtoList = Lists.newArrayList();
//        List<LmsFrameCustomerInvestigateDetail> list = lmsFrameCustomerInvestigateDetailService.list(Wrappers.query().in("id", ids).eq("investigate_id",investigateId));
//        for (LmsFrameCustomerInvestigateDetail entity: list) {
//            LmsFrameCustomerInvestigateDetailDto dto = getDto(entity);
//            dtoList.add(dto);
//        }
//
//        new LmsFrameCustomerInvestigateDetailExportHandler(dtoList).generater(response);
    }


//    private LmsFrameCustomerInvestigateDetailDto getDto(LmsFrameCustomerInvestigateDetail entity) {
//        LmsFrameCustomerInvestigateDetailDto dto = new LmsFrameCustomerInvestigateDetailDto();
//        dto.setInvestigateItem(entity.getInvestigateItem());
//        dto.setInvestigateStandard(entity.getInvestigateStandard());
//        if (null != entity.getCustomerStandard()) {
///*            if (SatisfactionEnum.VERY_SATISFIED.getValue().toString().equals(entity.getCustomerStandard().getValue().toString())) {
//                dto.setCustomerStandardStr("很满意");
//            } else if (SatisfactionEnum.SATISFIED.getValue().toString().equals(entity.getCustomerStandard().getValue().toString())) {
//                dto.setCustomerStandardStr("满意");
//            } else if (SatisfactionEnum.MORE_SATISFIED.getValue().toString().equals(entity.getCustomerStandard().getValue().toString())) {
//                dto.setCustomerStandardStr("较满意");
//            } else if (SatisfactionEnum.DISSATISFIED.getValue().toString().equals(entity.getCustomerStandard().getValue().toString())) {
//                dto.setCustomerStandardStr("不满意");
//            } else if (SatisfactionEnum.VERY_DISSATISFIED.getValue().toString().equals(entity.getCustomerStandard().getValue().toString())) {
//                dto.setCustomerStandardStr("很不满意");
//            } else {
//                dto.setCustomerStandardStr("");
//            }*/
//               dto.setCustomerStandardStr(entity.getCustomerStandard());
//        }
//        if(null != entity.getStatus()) {
//            dto.setStatus(entity.getStatus()==0? "草稿" : "已提交");
//        }
//        dto.setRemark(entity.getRemark());
//
//        return dto;
//    }

}
