package com.patzn.lims.frame.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.entity.LmsFrameInnerCheckManage;
import com.patzn.lims.frame.service.ILmsFrameInnerCheckManageService;
import com.patzn.lims.frame.vo.LmsFrameInnerCheckManageVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 内审实施管理 前端控制器
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Api(description = "内审实施管理")
@RestController
@RequestMapping("/v1/frame_inner_check_manage")
public class LmsFrameInnerCheckManageController extends ServiceController<ILmsFrameInnerCheckManageService,LmsFrameInnerCheckManage> {

    @Autowired
    private ILmsFrameInnerCheckManageService lmsFrameInnerCheckManageService;

    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")

	public PtResult<Page<LmsFrameInnerCheckManage>> getPage(LmsFrameInnerCheckManage lmsFrameInnerCheckManage) {
        return success(lmsFrameInnerCheckManageService.page(getPage(), lmsFrameInnerCheckManage));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")

    public PtResult<List<LmsFrameInnerCheckManage>> getList(LmsFrameInnerCheckManage lmsFrameInnerCheckManage) {
        return success(lmsFrameInnerCheckManageService.list(lmsFrameInnerCheckManage));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")

    public PtResult<LmsFrameInnerCheckManageVO> getVO(@PathVariable("id") Long id) {
        return success(lmsFrameInnerCheckManageService.getVOById(id));
    }


    @ApiOperation(value = "查询临时数据", notes = "查询临时数据")
    @GetMapping("/getTemp/")
    public PtResult<LmsFrameInnerCheckManageVO> getTemp() {
        return success(lmsFrameInnerCheckManageService.getTempVO());
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")

	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsFrameInnerCheckManage lmsFrameInnerCheckManage) {
        return success(lmsFrameInnerCheckManageService.edit(lmsFrameInnerCheckManage));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")

	public PtResult<Boolean> add(LmsFrameInnerCheckManage lmsFrameInnerCheckManage) {
        return success(lmsFrameInnerCheckManageService.add(lmsFrameInnerCheckManage));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")

	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameInnerCheckManageService.delete(ids));
	}


    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsFrameFile> uploadFile(@RequestParam("file") MultipartFile file, LmsFrameInnerCheckManage lmsFrameInnerCheckManage){
        return success(lmsFrameInnerCheckManageService.uploadFile(file, lmsFrameInnerCheckManage));
    }

    @ApiOperation(value = "下载附件", notes = "下载指定附件")
    @GetMapping("/downLoadFile")
    public void downloadFile(Long id) {
        lmsFrameInnerCheckManageService.downloadFile(id, response);
    }

    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile/")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id){
        return success(lmsFrameInnerCheckManageService.deleteFile(id));
    }


    @PostMapping("/submit/")
    public PtResult<Boolean> submit(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameInnerCheckManageService.submit(Arrays.asList(ids)));
    }


    @ApiOperation(value = "导出数据", notes = "导出数据")
    @GetMapping("/export")
    public void exportExcel(@RequestParam("ids") Long[] ids, @RequestParam("checkPlanId") Long checkPlanId) {
//        List<LmsFrameInnerCheckManageDto> dtoList = Lists.newArrayList();
//        List<LmsFrameInnerCheckManage> list = lmsFrameInnerCheckManageService.list(Wrappers.query().in("id", ids).eq("check_plan_id",checkPlanId));
//        for (LmsFrameInnerCheckManage entity: list) {
//            LmsFrameInnerCheckManageDto dto = getDto(entity);
//            dtoList.add(dto);
//        }
//        new LmsFrameInnerCheckManageExportHandler(dtoList).generater(response);
    }

//    private LmsFrameInnerCheckManageDto getDto(LmsFrameInnerCheckManage entity) {
//        LmsFrameInnerCheckManageDto dto = new LmsFrameInnerCheckManageDto();
//        dto.setCheckMemberName(entity.getCheckMemberName());
//
//        if (null != entity.getCheckManageTime()) {
//            dto.setCheckManageTimeStr(sdf.format(entity.getCheckManageTime()));
//        }
//        dto.setCheckManageItem(entity.getCheckManageItem());
//        dto.setCheckManageContent(entity.getCheckManageContent());
//        dto.setCheckManageResult(entity.getCheckManageResult());
//        dto.setRemark(entity.getRemark());
//        dto.setUname(entity.getUname());
//        SimpleDateFormat sdf =   new SimpleDateFormat( " yyyy-MM-dd" );
//        dto.setCtime(sdf.format(entity.getCtime()));
//        return dto;
//    }

}
