package com.patzn.lims.frame.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.entity.LmsFrameInnerCheckPlan;
import com.patzn.lims.frame.service.ILmsFrameInnerCheckPlanService;
import com.patzn.lims.frame.vo.LmsFrameInnerCheckPlanVO;
import com.patzn.lims.res.service.ILmsBaseDictService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.text.SimpleDateFormat;
import java.util.List;

/**
 * <p>
 * 内审实施计划 前端控制器
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Api(description = "内审实施计划")
@RestController
@RequestMapping("/v1/frame_inner_check_plan")
public class LmsFrameInnerCheckPlanController extends ServiceController<ILmsFrameInnerCheckPlanService,LmsFrameInnerCheckPlan>  {

    @Autowired
    private ILmsFrameInnerCheckPlanService lmsFrameInnerCheckPlanService;
    @Autowired
    private ILmsBaseDictService lmsBaseDictService;

    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")

	public PtResult<Page<LmsFrameInnerCheckPlan>> getPage(LmsFrameInnerCheckPlanVO lmsFrameInnerCheckPlan) {
        return success(lmsFrameInnerCheckPlanService.page(getPage(), lmsFrameInnerCheckPlan));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")

    public PtResult<List<LmsFrameInnerCheckPlan>> getList(LmsFrameInnerCheckPlan lmsFrameInnerCheckPlan) {
        return success(lmsFrameInnerCheckPlanService.list(lmsFrameInnerCheckPlan));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")

    public PtResult<LmsFrameInnerCheckPlanVO> getVO(@PathVariable("id") Long id) {
        return success(lmsFrameInnerCheckPlanService.getVOById(id));
    }


    @GetMapping("/getTemp/")
    public PtResult<LmsFrameInnerCheckPlanVO> getTemp() {
        return success(lmsFrameInnerCheckPlanService.getTempVO());
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")

	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsFrameInnerCheckPlan lmsFrameInnerCheckPlan) {
        return success(lmsFrameInnerCheckPlanService.edit(lmsFrameInnerCheckPlan));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")

	public PtResult<Boolean> add(LmsFrameInnerCheckPlan lmsFrameInnerCheckPlan) {
        return success(lmsFrameInnerCheckPlanService.add(lmsFrameInnerCheckPlan));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")

	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameInnerCheckPlanService.delete(ids));
	}

    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsFrameFile> uploadFile(@RequestParam("file") MultipartFile file, LmsFrameInnerCheckPlan lmsFrameInnerCheckPlan){
        return success(lmsFrameInnerCheckPlanService.uploadFile(file, lmsFrameInnerCheckPlan));
    }

    @ApiOperation(value = "下载附件", notes = "下载指定附件")
    @GetMapping("/downLoadFile")
    public void downloadFile(Long id) {
        lmsFrameInnerCheckPlanService.downloadFile(id, response);
    }

    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile/")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id){
        return success(lmsFrameInnerCheckPlanService.deleteFile(id));
    }


    @ApiOperation(value = "内审计划提交审批", notes = "内审计划提交审批")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键 ID 集合", required = true, paramType = "query", dataType = "array"),
    })
    @PostMapping("/submit/")
    public PtResult<Boolean> submitInnerCheckFlow(Long[] ids) {
        return success(null != lmsFrameInnerCheckPlanService.submitInnerCheckFlow(ids));
    }

    @PostMapping("/approve/{taskId}")
    public PtResult<Boolean> approve(@PathVariable("taskId") String taskId, String status, String reason) {
        return success(lmsFrameInnerCheckPlanService.approveFlow(taskId, status, reason));
    }



    @ApiOperation(value = "导出数据", notes = "导出数据")
    @GetMapping("/export")
    public void exportExcel(@RequestParam("ids") Long[] ids) {
//        List<LmsFrameInnerCheckPlanDto> dtoList = Lists.newArrayList();
//        List<LmsFrameInnerCheckPlan> list = lmsFrameInnerCheckPlanService.list(Wrappers.query().in("id", ids).eq("temp_status",1));
//        for (LmsFrameInnerCheckPlan entity: list) {
//            LmsFrameInnerCheckPlanDto dto = getDto(entity);
//            dtoList.add(dto);
//        }
//
//        new LmsFrameInnerCheckPlanExportHandler(dtoList).generater(response);
    }

//    private LmsFrameInnerCheckPlanDto getDto(LmsFrameInnerCheckPlan entity) {
//        LmsFrameInnerCheckPlanDto dto = new LmsFrameInnerCheckPlanDto();
//        dto.setCheckPlanPurpose(entity.getCheckPlanPurpose());
//
//        if (null != entity.getCheckPlanTime()) {
//            dto.setCheckPlanTimeStr(sdf.format(entity.getCheckPlanTime()));
//        }
//
//        dto.setCheckPlanBasis(entity.getCheckPlanBasis());
//        dto.setCheckPlanMethod(entity.getCheckPlanMethod());
//
//        if (null != entity.getCheckPlanType()) {
////            dto.setCheckPlanTypeStr(lmsBaseDictService.getByKey(entity.getCheckPlanType()).getLabel());
//            dto.setCheckPlanTypeStr(entity.getCheckPlanType());
//        }
//
//        dto.setCheckPlanRange(entity.getCheckPlanRange());
//        dto.setCheckGroupLeaderName(entity.getCheckGroupLeaderName());
//        dto.setCheckGroupMemberNames(entity.getCheckGroupMemberNames());
//        dto.setCheckPlanContent(entity.getCheckPlanContentText());
//        dto.setApplyName(entity.getApplyName());
//        if (null != entity.getApplyTime()) {
//            dto.setApplyTimeStr(sdf.format(entity.getApplyTime()));
//        }
//
//        dto.setAuditName(entity.getAuditName());
//        if (null != entity.getAuditTime()) {
//            dto.setApplyTimeStr(sdf.format(entity.getAuditTime()));
//        }
//
//        dto.setRemark(entity.getRemark());
//        if(null!=entity.getStatus()){
//            dto.setStatus(entity.getStatus().getDisplay());
//        }
//        return dto;
//    }

}
