package com.patzn.lims.frame.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.entity.LmsFrameInnerCheckReport;
import com.patzn.lims.frame.service.ILmsFrameInnerCheckReportService;
import com.patzn.lims.frame.vo.LmsFrameInnerCheckReportVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 内审报告表 前端控制器
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Api(description = "内审报告表")
@RestController
@RequestMapping("/v1/frame_inner_check_report")
public class LmsFrameInnerCheckReportController extends ServiceController<ILmsFrameInnerCheckReportService,LmsFrameInnerCheckReport> {

    @Autowired
    private ILmsFrameInnerCheckReportService lmsFrameInnerCheckReportService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")

	public PtResult<Page<LmsFrameInnerCheckReport>> getPage(LmsFrameInnerCheckReport lmsFrameInnerCheckReport) {
        return success(lmsFrameInnerCheckReportService.page(getPage(), lmsFrameInnerCheckReport));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")

    public PtResult<List<LmsFrameInnerCheckReport>> getList(LmsFrameInnerCheckReport lmsFrameInnerCheckReport) {
        return success(lmsFrameInnerCheckReportService.list(lmsFrameInnerCheckReport));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")

    public PtResult<LmsFrameInnerCheckReportVO> getVO(@PathVariable("id") Long id) {
        return success(lmsFrameInnerCheckReportService.getVOById(id));
    }


    @ApiOperation(value = "查询临时数据", notes = "查询临时数据")
    @GetMapping("/getTemp/")
    public PtResult<LmsFrameInnerCheckReportVO> getTemp() {
        return success(lmsFrameInnerCheckReportService.getTempVO());
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")

	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsFrameInnerCheckReport lmsFrameInnerCheckReport) {
        return success(lmsFrameInnerCheckReportService.edit(lmsFrameInnerCheckReport));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")

	public PtResult<Boolean> add(LmsFrameInnerCheckReport lmsFrameInnerCheckReport) {
        return success(lmsFrameInnerCheckReportService.add(lmsFrameInnerCheckReport));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")

	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameInnerCheckReportService.delete(ids));
	}

    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsFrameFile> uploadFile(@RequestParam("file") MultipartFile file, LmsFrameInnerCheckReport lmsFrameInnerCheckReport){
        return success(lmsFrameInnerCheckReportService.uploadFile(file, lmsFrameInnerCheckReport));
    }

    @ApiOperation(value = "下载附件", notes = "下载指定附件")
    @GetMapping("/downLoadFile")
    public void downloadFile(Long id) {
        lmsFrameInnerCheckReportService.downloadFile(id, response);
    }


    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile/")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id){
        return success(lmsFrameInnerCheckReportService.deleteFile(id));
    }


    @PostMapping("/submit/")
    public PtResult<Boolean> submit(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameInnerCheckReportService.submit(Arrays.asList(ids)));
    }

}
