package com.patzn.lims.frame.controller;

import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Login;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.cloud.commons.toolkit.UploadUtils;
import com.patzn.lims.frame.entity.LmsFrameProblemImproveAttachment;
import com.patzn.lims.frame.service.ILmsFrameProblemImproveAttachmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import java.util.Iterator;
import java.util.List;

/**
 * <p>
 * 改进/纠正/预防措施管理附件表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-07-18
 */
@Api(description = "改进/纠正/预防措施管理附件表")
@RestController
@RequestMapping("/v1/frame_problem_improve_attachment")
public class LmsFrameProblemImproveAttachmentController extends ServiceController <ILmsFrameProblemImproveAttachmentService,LmsFrameProblemImproveAttachment> {

    @Autowired
    private ILmsFrameProblemImproveAttachmentService lmsFrameProblemImproveAttachmentService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")

	public PtResult<Page<LmsFrameProblemImproveAttachment>> getPage(LmsFrameProblemImproveAttachment lmsFrameProblemImproveAttachment) {
        return success(lmsFrameProblemImproveAttachmentService.page(getPage(), lmsFrameProblemImproveAttachment));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")

    public PtResult<List<LmsFrameProblemImproveAttachment>> getList(LmsFrameProblemImproveAttachment lmsFrameProblemImproveAttachment) {
        return success(lmsFrameProblemImproveAttachmentService.list(lmsFrameProblemImproveAttachment));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")

    public PtResult<LmsFrameProblemImproveAttachment> get(@PathVariable("id") Long id) {
        return success(lmsFrameProblemImproveAttachmentService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")

	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsFrameProblemImproveAttachment lmsFrameProblemImproveAttachment) {
        lmsFrameProblemImproveAttachment.setId(id);
        return success(lmsFrameProblemImproveAttachmentService.updateById(lmsFrameProblemImproveAttachment));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")

	public PtResult<Boolean> add(LmsFrameProblemImproveAttachment lmsFrameProblemImproveAttachment) {
        return success(lmsFrameProblemImproveAttachmentService.save(lmsFrameProblemImproveAttachment));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")

	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameProblemImproveAttachmentService.remove(Wrappers.<LmsFrameProblemImproveAttachment>query().in("id", ids)));
	}


    @ApiOperation(value = "上传改进纠正预防措施管理附件", notes = "上传改进纠正预防措施管理附件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "problemImproveId", value = "改进纠正预防措施管理 ID", required = true, paramType = "path", dataType = "long"),
    })
    @PostMapping("/{problemImproveId}")
    public PtResult<Boolean> uploadAttachment(@PathVariable("problemImproveId") Long problemImproveId, MultipartHttpServletRequest mhsr) {
        if (UploadUtils.resumeUpload(request)) {
            return null;
        }
        Iterator<String> fns = mhsr.getFileNames();
        while (fns.hasNext()) {
            // 获取上传的文件列表
            return success(lmsFrameProblemImproveAttachmentService.save(problemImproveId, mhsr.getFile(fns.next())));
        }
        return success(false);
    }

    @ApiOperation(value = "下载改进纠正预防措施管理附件", notes = "根据 id 下载文件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @Login(action = Action.Skip)
    @GetMapping("/download/{id}")
    public void download(@PathVariable("id") Long id) {
        lmsFrameProblemImproveAttachmentService.download(id, response);
    }

}
