package com.patzn.lims.frame.controller;


import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.cloud.commons.toolkit.JacksonUtils;
import com.patzn.lims.frame.dto.LmsFrameProblemApproveDTO;
import com.patzn.lims.frame.entity.LmsFrameProblemImprove;
import com.patzn.lims.frame.entity.LmsFrameProblemImproveAttachment;
import com.patzn.lims.frame.service.ILmsFrameProblemImproveService;
import com.patzn.lims.frame.vo.LmsFrameProblemImproveVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 改进/纠正/预防措施管理 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-07-18
 */
@Api(description = "改进/纠正/预防措施管理")
@RestController
@RequestMapping("/v1/frame_problem_improve")
public class LmsFrameProblemImproveController extends ServiceController<ILmsFrameProblemImproveService,LmsFrameProblemImprove>  {

    @Autowired
    private ILmsFrameProblemImproveService lmsFrameProblemImproveService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")

    public PtResult<Page<LmsFrameProblemImprove>> getPage(LmsFrameProblemImprove lmsFrameProblemImprove) {
        lmsFrameProblemImprove.setTempStatus(1);
        Page<LmsFrameProblemImprove> page = lmsFrameProblemImproveService.page(getPage(), lmsFrameProblemImprove);
        return success(page);
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")

    public PtResult<List<LmsFrameProblemImprove>> getList(LmsFrameProblemImprove lmsFrameProblemImprove) {
        return success(lmsFrameProblemImproveService.list(lmsFrameProblemImprove));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")

    public PtResult<LmsFrameProblemImproveVO> getVO(@PathVariable("id") Long id) {
        return success(lmsFrameProblemImproveService.getVOById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")

    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsFrameProblemImprove lmsFrameProblemImprove) {
        lmsFrameProblemImprove.setId(id);
        return success(lmsFrameProblemImproveService.updateFrameProblemImproveById(lmsFrameProblemImprove));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")

    public PtResult<Boolean> add(LmsFrameProblemImprove lmsFrameProblemImprove) {
        lmsFrameProblemImprove.setTempStatus(1);
        return success(lmsFrameProblemImproveService.add(lmsFrameProblemImprove));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")

    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameProblemImproveService.remove(Wrappers.<LmsFrameProblemImprove>query().in("id", ids)));
    }


    @ApiOperation(value = "提交改进/纠正/预防措施管理提交", notes = "改进/纠正/预防措施管理提交")
    @PostMapping("/submit")
    public PtResult<Boolean> submit(@RequestParam("ids") Long[] ids) {
        return success(null != lmsFrameProblemImproveService.submitCheckFlow(ids, getAccount()));
    }

    @PostMapping("/approve/{taskId}")
    public PtResult<Boolean> approve(@PathVariable("taskId") String taskId, String status, String reason) {
        return success(lmsFrameProblemImproveService.approveFlow(taskId, status, reason));
    }

    @ApiOperation(value = "导出改进/纠正/预防措施", notes = "导出改进/纠正/预防措施")
    @PostMapping("/problem_improve")
    public void exportItem(@RequestParam String request) {
        LmsFrameProblemApproveDTO dto = JacksonUtils.readValue(request, LmsFrameProblemApproveDTO.class);
        if (null != dto) {
            lmsFrameProblemImproveService.exportItem(response, dto);
        }
    }


    @GetMapping("/getTemp/")
    public PtResult<LmsFrameProblemImproveVO> getTemp() {
        return success(lmsFrameProblemImproveService.getTempVO());
    }


    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsFrameProblemImproveAttachment> uploadFile(@RequestParam("file") MultipartFile file, LmsFrameProblemImproveVO lmsFrameProblemImproveVO) {
        return success(lmsFrameProblemImproveService.uploadFile(file, lmsFrameProblemImproveVO));
    }

    @ApiOperation(value = "下载附件", notes = "下载指定附件")
    @GetMapping("/downLoadFile")
    public void downloadFile(Long id) {
        lmsFrameProblemImproveService.downloadFile(id, response);
    }


    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile/")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id) {
        return success(lmsFrameProblemImproveService.deleteFile(id));
    }


}
