package com.patzn.lims.frame.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.entity.LmsFrameUnconformImprove;
import com.patzn.lims.frame.service.ILmsFrameUnconformImproveService;
import com.patzn.lims.frame.vo.LmsFrameUnconformImproveVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 不符合项 前端控制器
 * </p>
 *
 * @author patzn123
 * @since 2018-01-10
 */
@Api(description = "不符合项")
@RestController
@RequestMapping("/v1/frame_unconform_improve")
public class LmsFrameUnconformImproveController extends ServiceController<ILmsFrameUnconformImproveService,LmsFrameUnconformImprove> {

    @Autowired
    private ILmsFrameUnconformImproveService lmsFrameUnconformImproveService;

    private SimpleDateFormat sdf0 = new SimpleDateFormat("yyyy-MM-dd");

    private SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")

	public PtResult<Page<LmsFrameUnconformImprove>> getPage(LmsFrameUnconformImprove lmsFrameUnconformImprove) {
        return success(lmsFrameUnconformImproveService.page(getPage(), lmsFrameUnconformImprove));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")

    public PtResult<List<LmsFrameUnconformImprove>> getList(LmsFrameUnconformImprove lmsFrameUnconformImprove) {
        return success(lmsFrameUnconformImproveService.list(lmsFrameUnconformImprove));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")

    public PtResult<LmsFrameUnconformImproveVO> getVO(@PathVariable("id") Long id) {
        return success(lmsFrameUnconformImproveService.getVOById(id));
    }


    @GetMapping("/getTemp/")
    public PtResult<LmsFrameUnconformImproveVO> getTemp() {
        return success(lmsFrameUnconformImproveService.getTempVO());
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")

	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsFrameUnconformImprove lmsFrameUnconformImprove) {
        return success(lmsFrameUnconformImproveService.updateById(lmsFrameUnconformImprove));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")

	public PtResult<Boolean> add(LmsFrameUnconformImprove lmsFrameUnconformImprove) {
        return success(lmsFrameUnconformImproveService.add(lmsFrameUnconformImprove));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")

	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameUnconformImproveService.delete(ids));
	}



    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsFrameFile> uploadFile(@RequestParam("file") MultipartFile file, LmsFrameUnconformImprove lmsFrameUnconformImprove){
        return success(lmsFrameUnconformImproveService.uploadFile(file, lmsFrameUnconformImprove));
    }

    @ApiOperation(value = "下载附件", notes = "下载指定附件")
    @GetMapping("/downLoadFile")
    public void downloadFile(Long id) {
        lmsFrameUnconformImproveService.downloadFile(id, response);
    }

    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile/")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id){
        return success(lmsFrameUnconformImproveService.deleteFile(id));
    }


    @PostMapping("/submit/")
    public PtResult<Boolean> submit(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameUnconformImproveService.submit(Arrays.asList(ids)));
    }

    @ApiOperation(value = "导出数据", notes = "导出数据")
    @GetMapping("/export")
    public void exportExcel(@RequestParam("ids") List<Long> ids) {
//        List<LmsFrameUnconformImproveDto> dtoList = Lists.newArrayList();
//        List<LmsFrameUnconformImprove> list = lmsFrameUnconformImproveService.list(Wrappers.query().in("id", ids));
//        for (LmsFrameUnconformImprove entity: list) {
//            LmsFrameUnconformImproveDto dto = getDto(entity);
//            dtoList.add(dto);
//        }
//
//        new LmsFrameUnconformImproveExportHandler(dtoList).generater(response);
    }

//    private LmsFrameUnconformImproveDto getDto(LmsFrameUnconformImprove entity) {
//        LmsFrameUnconformImproveDto dto = new LmsFrameUnconformImproveDto();
//        dto.setQuestion(entity.getQuestion());
//        dto.setMethod(entity.getMethod());
//        if (null != entity.getExpiryDate()) {
//            dto.setExpiryDateStr(sdf0.format(entity.getExpiryDate()));
//        }
//
//        dto.setApplyName(entity.getApplyName());
//        if (null != entity.getApplyTime()) {
//            dto.setApplyTimeStr(sdf1.format(entity.getApplyTime()));
//        }
//
//        dto.setManagerName(entity.getManagerName());
//        dto.setCheckerName(entity.getCheckerName());
//
//        dto.setRemark(entity.getRemark());
//
//        return dto;
//    }

}
