package com.patzn.lims.frame.controller;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.entity.LmsFrameUnconformRegister;
import com.patzn.lims.frame.service.ILmsFrameUnconformRegisterService;
import com.patzn.lims.frame.vo.LmsFrameUnconformRegisterVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.text.SimpleDateFormat;
import java.util.List;

/**
 * <p>
 * 不符合项登记 前端控制器
 * </p>
 *
 * @author patzn123
 * @since 2018-01-10
 */
@Api(description = "不符合项登记")
@RestController
@RequestMapping("/v1/frame_unconform_register")
public class LmsFrameUnconformRegisterController extends ServiceController<ILmsFrameUnconformRegisterService,LmsFrameUnconformRegister>{

    @Autowired
    private ILmsFrameUnconformRegisterService lmsFrameUnconformRegisterService;

    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")

	public PtResult<Page<LmsFrameUnconformRegister>> getPage(LmsFrameUnconformRegister lmsFrameUnconformRegister) {
        return success(lmsFrameUnconformRegisterService.page(getPage(), lmsFrameUnconformRegister));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")

    public PtResult<List<LmsFrameUnconformRegister>> getList(LmsFrameUnconformRegister lmsFrameUnconformRegister) {
        return success(lmsFrameUnconformRegisterService.list(lmsFrameUnconformRegister));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")

    public PtResult<LmsFrameUnconformRegisterVO> getVO(@PathVariable("id") Long id) {
        return success(lmsFrameUnconformRegisterService.getVOById(id));
    }


    @GetMapping("/getTemp/")
    public PtResult<LmsFrameUnconformRegisterVO> getTemp() {
        return success(lmsFrameUnconformRegisterService.getTempVO());
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")

	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsFrameUnconformRegister lmsFrameUnconformRegister) {
        return success(lmsFrameUnconformRegisterService.updateUnconformRegisterById(lmsFrameUnconformRegister));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")

	public PtResult<Boolean> add(LmsFrameUnconformRegister lmsFrameUnconformRegister) {
        return success(lmsFrameUnconformRegisterService.add(lmsFrameUnconformRegister));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")

	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsFrameUnconformRegisterService.delete(ids));
	}


    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsFrameFile> uploadFile(@RequestParam("file") MultipartFile file, LmsFrameUnconformRegister lmsFrameUnconformRegister){
        return success(lmsFrameUnconformRegisterService.uploadFile(file, lmsFrameUnconformRegister));
    }

    @ApiOperation(value = "下载附件", notes = "下载指定附件")
    @GetMapping("/downLoadFile")
    public void downloadFile(Long id) {
        lmsFrameUnconformRegisterService.downloadFile(id, response);
    }

    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile/")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id){
        return success(lmsFrameUnconformRegisterService.deleteFile(id));
    }


    @PostMapping("/submit/")
    public PtResult<Boolean> submit(@RequestParam("id") Long[] ids) {
        return success(null != lmsFrameUnconformRegisterService.submit(ids, getAccount()));
    }


    @PostMapping("/approve/{taskId}")
    public PtResult<Boolean> approve(@PathVariable("taskId") String taskId, String status, String reason, String audit) {
        return success(lmsFrameUnconformRegisterService.approve(taskId, status, reason, audit));
    }

    @ApiOperation(value = "导出数据", notes = "导出数据")
    @GetMapping("/export")
    public void exportExcel(@RequestParam("ids") List<Long> ids) {
//        List<LmsFrameUnconformRegisterDto> dtoList = Lists.newArrayList();
//        List<LmsFrameUnconformRegister> list = lmsFrameUnconformRegisterService.list(Wrappers.query().in("id", ids).eq("temp_status",1));
//        for (LmsFrameUnconformRegister entity: list) {
//            LmsFrameUnconformRegisterDto dto = getDto(entity);
//            dtoList.add(dto);
//        }
//        new LmsFrameUnconformRegisterExportHandler(dtoList).generater(response);
    }

//    private LmsFrameUnconformRegisterDto getDto(LmsFrameUnconformRegister entity) {
//        LmsFrameUnconformRegisterDto dto = new LmsFrameUnconformRegisterDto();
//        dto.setOrgName(entity.getOrgName());
//        dto.setOrgManagerName(entity.getOrgManagerName());
//        dto.setUnconformItem(entity.getUnconformItem());
//        if (null != entity.getRegisterTime()) {
//            dto.setRegisterTimeStr(sdf.format(entity.getRegisterTime()));
//        }
//
//        dto.setRegisterName(entity.getRegisterName());
//        dto.setUnconformReason(entity.getUnconformReason());
//        dto.setOrgManagerAudit(entity.getOrgManagerAudit());
//        if (null != entity.getOrgManagerTime()) {
//            dto.setOrgManagerTimeStr(sdf.format(entity.getOrgManagerTime()));
//        }
//
//        dto.setVerifyPlan(entity.getVerifyPlan());
//        dto.setQualityManagerAudit(entity.getQualityManagerAudit());
//        if (null != entity.getQualityManagerTime()) {
//            dto.setQualityManagerTimeStr(sdf.format(entity.getQualityManagerTime()));
//        }
//        dto.setVerifyFinish(entity.getVerifyFinish());
//        dto.setOrgManagerAudit2(entity.getOrgManagerAudit2());
//        if (null != entity.getOrgManagerTime()) {
//            dto.setOrgManagerTime2Str(sdf.format(entity.getOrgManagerTime()));
//        }
//        dto.setVerifyCheck(entity.getVerifyCheck());
//        dto.setQualityManagerAudit2(entity.getQualityManagerAudit2());
//        if (null != entity.getQualityManagerTime()) {
//            dto.setQualityManagerTime2Str(sdf.format(entity.getQualityManagerTime()));
//        }
//        dto.setRemark(entity.getRemark());
//
//        return dto;
//    }

}
