package com.patzn.lims.frame.controller;

import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Login;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.common.UploadUtils;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsMonthPlanAttachment;
import com.patzn.lims.frame.service.ILmsMonthPlanAttachmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import java.util.Iterator;
import java.util.List;

/**
 * <p>
 * 年度计划子表附件表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-06-26
 */
@Api(description = "年度计划子表附件表")
@RestController
@RequestMapping("/v1/month_plan_attachment")
public class LmsMonthPlanAttachmentController extends ServiceController<ILmsMonthPlanAttachmentService,LmsMonthPlanAttachment> {

    @Autowired
    private ILmsMonthPlanAttachmentService lmsMonthPlanAttachmentService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsMonthPlanAttachment>> getPage(LmsMonthPlanAttachment lmsMonthPlanAttachment) {
        return success(lmsMonthPlanAttachmentService.page(getPage(), lmsMonthPlanAttachment));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsMonthPlanAttachment>> getList(LmsMonthPlanAttachment lmsMonthPlanAttachment) {
        return success(lmsMonthPlanAttachmentService.list(lmsMonthPlanAttachment));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    @Override
    public PtResult<LmsMonthPlanAttachment> get(@PathVariable("id") Long id) {
        return success(lmsMonthPlanAttachmentService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsMonthPlanAttachment lmsMonthPlanAttachment) {
        lmsMonthPlanAttachment.setId(id);
        return success(lmsMonthPlanAttachmentService.updateById(lmsMonthPlanAttachment));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
	public PtResult<Boolean> add(LmsMonthPlanAttachment lmsMonthPlanAttachment) {
        return success(lmsMonthPlanAttachmentService.save(lmsMonthPlanAttachment));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsMonthPlanAttachmentService.remove(Wrappers.<LmsMonthPlanAttachment>query().in("id", ids)));
	}


    @ApiOperation(value = "上传计划附件", notes = "上传计划附件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "planId", value = "计划 ID", required = true, paramType = "path", dataType = "long"),
    })
    @PostMapping("/{planId}")
    public PtResult<Boolean> uploadAttachment(@PathVariable("planId") Long planId, MultipartHttpServletRequest mhsr) {
        if (UploadUtils.resumeUpload(request)) {
            return null;
        }

        Iterator<String> fns = mhsr.getFileNames();
        while (fns.hasNext()) {
            // 获取上传的文件列表
            return success(lmsMonthPlanAttachmentService.save(planId, mhsr.getFile(fns.next())));
        }
        return success(false);
    }


    @ApiOperation(value = "下载计划附件文件", notes = "根据 id 下载计划附件文件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @Login(action = Action.Skip)
    @GetMapping("/download/{id}")
    public void download(@PathVariable("id") Long id) {
        lmsMonthPlanAttachmentService.download(id, response);
    }

    @ApiOperation(value = "批量打包下载", notes = "批量打包下载")
    @GetMapping("/download_batch")
    public void downloadBatch(Long[] attachmentIds) {
        lmsMonthPlanAttachmentService.downloadBatch(attachmentIds, response);
    }

}
