package com.patzn.lims.frame.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsMonthPlan;
import com.patzn.lims.frame.enums.PlanStatusEnum;
import com.patzn.lims.frame.service.ILmsMonthPlanService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 年度计划子表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-06-26
 */
@Api(description = "年度计划子表")
@RestController
@RequestMapping("/v1/month_plan")
public class LmsMonthPlanController extends ServiceController<ILmsMonthPlanService,LmsMonthPlan> {

    @Autowired
    private ILmsMonthPlanService lmsMonthPlanService;


    @ApiOperation(value = "评定计划根据计划id查询子计划分页列表", notes = "评定计划根据计划id查询子计划分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<IPage<LmsMonthPlan>> getPage(LmsMonthPlan lmsMonthPlan, Date startDate, Date endDate) {
        return success(lmsMonthPlanService.page(getPage(), lmsMonthPlan, startDate, endDate));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsMonthPlan>> getList(LmsMonthPlan lmsMonthPlan) {
        return success(lmsMonthPlanService.list(lmsMonthPlan));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    @Override
    public PtResult<LmsMonthPlan> get(@PathVariable("id") Long id) {
        return success(lmsMonthPlanService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsMonthPlan lmsMonthPlan) {
        lmsMonthPlan.setId(id);
        return success(lmsMonthPlanService.updatePlanById(lmsMonthPlan));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
    public PtResult<Boolean> add(LmsMonthPlan lmsMonthPlan) {
        PtAssert.fail(null == lmsMonthPlan || null == lmsMonthPlan.getYearPlanId(), "请选择年度计划");
        lmsMonthPlan.setStatus((Integer) PlanStatusEnum.DRAFT.getValue());
        lmsMonthPlan.setUname(LoginHelper.getAccount().getUserName());
        return success(lmsMonthPlanService.save(lmsMonthPlan));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsMonthPlanService.remove(Wrappers.<LmsMonthPlan>query().in("id", ids)));
    }


    @ApiOperation(value = "评定计划根据计划id查询子计划分页列表", notes = "评定计划根据计划id查询子计划分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_plan")
    public PtResult<IPage<LmsMonthPlan>> getPagePlan(@RequestParam("planId") Long planId) {
        return success(lmsMonthPlanService.pagePlan(getPage(), planId));
    }


    @ApiOperation(value = "复制年度子计划", notes = "复制年度子计划")
    @PostMapping("/copy")
    public PtResult<Boolean> copy(LmsMonthPlan lmsMonthPlan) {
        return success(lmsMonthPlanService.copy(lmsMonthPlan));
    }


    @ApiOperation(value = "提交年度子计划", notes = "提交年度子计划")
    @PostMapping("/submit")
    public PtResult<Boolean> submit(@RequestParam("ids") Long[] ids, @RequestParam("endDate") Date endDate) {
        return success(lmsMonthPlanService.submit(ids, endDate));
    }


    @ApiOperation(value = "评定报告根据计划id查询子计划分页列表", notes = "评定报告根据计划id查询子计划分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_report")
    public PtResult<IPage<LmsMonthPlan>> getPageReport(@RequestParam("planId") Long planId) {
        return success(lmsMonthPlanService.pageReport(getPage(), planId));
    }


    @ApiOperation(value = "评定计划根据计划ids导出", notes = "评定计划根据计划ids导出")
    @PostMapping("/export_month_plan")
    public void exportMonthPlan(@RequestParam("ids") Long[] ids) {
        lmsMonthPlanService.exportMonthPlan(ids, response);
    }


    @ApiOperation(value = "评定报告根据计划ids导出", notes = "评定报告根据计划ids导出")
    @PostMapping("/export_month_report")
    public void exportMonthReport(@RequestParam("ids") Long[] ids) {
        lmsMonthPlanService.exportMonthReport(ids, response);
    }


    @ApiOperation(value = "导入计划", notes = "导入计划")
    @PostMapping("/import_month_plan")
    public PtResult<Boolean> importMonthPlan(MultipartFile file, @RequestParam("yearPlanId") Long yearPlanId) {
        return success(lmsMonthPlanService.importMonthPlan(file, yearPlanId, getAccount()));
    }

}
