package com.patzn.lims.frame.controller;

import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsQcMainPlanAttachment;
import com.patzn.lims.frame.service.ILmsQcMainPlanAttachmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 内部质控计划子表附件表 前端控制器
 * </p>
 *
 * @author xutao
 * @since 2019-09-09
 */
@Api(description = "内部质控计划主表附件表")
@RestController
@RequestMapping("/v1/qc_main_plan_attachment")
public class LmsQcMainPlanAttachmentController extends ServiceController<ILmsQcMainPlanAttachmentService, LmsQcMainPlanAttachment> {

    @Autowired
    private ILmsQcMainPlanAttachmentService lmsQcMainPlanAttachmentService;


    @ApiOperation(value = "下载附件", notes = "下载指定附件")
    @GetMapping("/download/{id}")
    public void downloadFile(@PathVariable("id")Long id) {
        lmsQcMainPlanAttachmentService.downloadFile(id, response);
    }



}
