package com.patzn.lims.frame.controller;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.cloud.commons.api.RestAssert;
import com.patzn.cloud.commons.api.RestConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsQcMainPlan;
import com.patzn.lims.frame.entity.LmsQcMainPlanAttachment;
import com.patzn.lims.frame.enums.PlanStatusEnum;import com.patzn.lims.frame.service.ILmsQcMainPlanService;
import com.patzn.lims.frame.vo.LmsQcMainPlanVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 内部质控计划主表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-07-09
 */
@Api(description = "内部质控计划主表")
@RestController
@RequestMapping("/v1/qc_main_plan")
public class LmsQcMainPlanController extends ServiceController<ILmsQcMainPlanService,LmsQcMainPlan> {

    @Autowired
    private ILmsQcMainPlanService lmsQcMainPlanService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = RestConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = RestConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = RestConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = RestConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<IPage<LmsQcMainPlan>> getPage(LmsQcMainPlan lmsQcMainPlan) {
        lmsQcMainPlan.setTempStatus(1);
        return success(baseService.page(getPage(), lmsQcMainPlan));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsQcMainPlan>> getList(LmsQcMainPlan lmsQcMainPlan) {
        return success(lmsQcMainPlanService.list(lmsQcMainPlan));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    @Override
    public PtResult<LmsQcMainPlan> get(@PathVariable("id") Long id) {
        return success(lmsQcMainPlanService.getVOById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsQcMainPlan lmsQcMainPlan) {
        lmsQcMainPlan.setId(id);
        return success(lmsQcMainPlanService.updatePlanById(lmsQcMainPlan));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
    public PtResult<Boolean> add(LmsQcMainPlan lmsQcMainPlan) {
        lmsQcMainPlan.setStatus((Integer)PlanStatusEnum.DRAFT.getValue());
        lmsQcMainPlan.setProgress((Integer) PlanStatusEnum.DRAFT.getValue());
        lmsQcMainPlan.setTempStatus(1);
        return success(lmsQcMainPlanService.add(lmsQcMainPlan));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsQcMainPlanService.removeByIds(ids));
    }


    @ApiOperation(value = "质控计划页面主表分页列表", notes = "质控计划页面主表分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = RestConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = RestConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = RestConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = RestConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_main_plan")
    public PtResult<IPage<LmsQcMainPlan>> getPageMainPlan(LmsQcMainPlan lmsQcMainPlan, Date startDate, Date endDate) {
        return success(lmsQcMainPlanService.pageMainPlan(getPage(), lmsQcMainPlan, startDate, endDate));
    }


    @ApiOperation(value = "质控记录页面主表分页列表", notes = "质控记录页面主表分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = RestConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = RestConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = RestConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = RestConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_main_record")
    public PtResult<IPage<LmsQcMainPlan>> getPageMainRecord(LmsQcMainPlan lmsQcMainPlan, Date startDate, Date endDate) {
        lmsQcMainPlan.setStatus((Integer)PlanStatusEnum.PASS.getValue());
        return success(lmsQcMainPlanService.pageMainPlan(getPage(), lmsQcMainPlan, startDate, endDate));
    }


    @ApiOperation(value = "复制质控主计划计划", notes = "复制质控主计划计划")
    @PostMapping("/copy")
    public PtResult<Boolean> copy(LmsQcMainPlan lmsQcMainPlan) {
        return success(lmsQcMainPlanService.copy(lmsQcMainPlan, getAccount()));
    }


    @ApiOperation(value = "质控计划提交至审批", notes = "质控计划提交至审批")
    @PostMapping("/submit_flow")
    public PtResult<Boolean> submit(@RequestParam("ids") Long[] ids) {
        return success(null != lmsQcMainPlanService.submitCheckFlow(ids, getAccount()));
    }


    @ApiOperation(value = "质控计划审批(pass or back)", notes = "质控计划审批(pass or back)")
    @PostMapping("/approve/{taskId}")
    public PtResult<Boolean> approve(@PathVariable("taskId") String taskId, String status, String reason) {
        return success(lmsQcMainPlanService.approveFlow(taskId, status, reason));
    }


    @ApiOperation(value = "导出内部质控计划", notes = "导出内部质控计划")
    @PostMapping("/export_plan")
    public void exportPlan(@RequestParam("id") Long id) {
        RestAssert.fail(null == id, "请选择导出计划");
        lmsQcMainPlanService.exportPlan(response, id);
    }


    @GetMapping("/getTemp/")
    public PtResult<LmsQcMainPlanVO> getTemp() {
        return success(lmsQcMainPlanService.getTempVO());
    }

    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsQcMainPlanAttachment> uploadFile(@RequestParam("file") MultipartFile file, LmsQcMainPlan lmsQcMainPlan) {
        return success(lmsQcMainPlanService.uploadFile(file, lmsQcMainPlan));
    }

    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile/")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id) {
        return success(lmsQcMainPlanService.deleteFile(id));
    }

}
