package com.patzn.lims.frame.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsQcSubPlan;
import com.patzn.lims.frame.enums.PlanStatusEnum;import com.patzn.lims.frame.service.ILmsQcSubPlanService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 内部质控计划子表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-07-09
 */
@Api(description = "内部质控计划子表")
@RestController
@RequestMapping("/v1/qc_sub_plan")
public class LmsQcSubPlanController extends ServiceController<ILmsQcSubPlanService,LmsQcSubPlan> {

    @Autowired
    private ILmsQcSubPlanService lmsQcSubPlanService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<IPage<LmsQcSubPlan>> getPage(LmsQcSubPlan lmsQcSubPlan) {
        return success(lmsQcSubPlanService.page(getPage(), lmsQcSubPlan));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsQcSubPlan>> getList(LmsQcSubPlan lmsQcSubPlan) {
        return success(lmsQcSubPlanService.list(lmsQcSubPlan));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    @Override
    public PtResult<LmsQcSubPlan> get(@PathVariable("id") Long id) {
        return success(lmsQcSubPlanService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsQcSubPlan lmsQcSubPlan) {
        lmsQcSubPlan.setId(id);
        return success(lmsQcSubPlanService.updatePlanById(lmsQcSubPlan));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(LmsQcSubPlan lmsQcSubPlan) {
        PtAssert.fail(null == lmsQcSubPlan || null == lmsQcSubPlan.getMainPlanId(), "请确认主计划");
        lmsQcSubPlan.setStatus((Integer)PlanStatusEnum.DRAFT.getValue());
        lmsQcSubPlan.setProgress((Integer) PlanStatusEnum.DRAFT.getValue());
        lmsQcSubPlan.setUname(LoginHelper.getAccount().getUserName());
        return success(lmsQcSubPlanService.save(lmsQcSubPlan));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsQcSubPlanService.removeByIds(ids));
    }


    @ApiOperation(value = "复制子计划", notes = "复制子计划")
    @PostMapping("/copy")
    public PtResult<Boolean> copy(LmsQcSubPlan lmsQcSubPlan) {
        return success(lmsQcSubPlanService.copy(lmsQcSubPlan, getAccount()));
    }


    @ApiOperation(value = "提交子计划", notes = "提交子计划")
    @PostMapping("/submit")
    public PtResult<Boolean> submit(Long[] ids, String result, Date endDate) {
        return success(lmsQcSubPlanService.submit(ids, result, endDate));
    }


    @ApiOperation(value = "子计划分页列表", notes = "子计划分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_sub_plan")
    public PtResult<IPage<LmsQcSubPlan>> getPageSubPlan(LmsQcSubPlan lmsQcSubPlan, Date startDate, Date endDate) {
        return success(lmsQcSubPlanService.pageSubPlan(getPage(), lmsQcSubPlan, startDate, endDate));
    }


    @ApiOperation(value = "导出数据", notes = "导出数据")
    @PostMapping("/export")
    public void exportExcel(@RequestParam("ids") List<Long> ids) {
//        List<LmsQcSubPlanDTO> dtoList = Lists.newArrayList();
//        List<LmsQcSubPlan> list = lmsQcSubPlanService.list(Condition.create().in("id", ids));
//        for (LmsQcSubPlan entity : list) {
//            LmsQcSubPlanDTO dto = entity.convert(LmsQcSubPlanDTO.class);
//            if (dto.getCompletion() != null) {
//                dto.setCompleteTime(DateUtils.toYearMonthDay(dto.getCompletion()));
//            }
//            if (dto.getTime() != null) {
//                dto.setTime(dto.getTime().substring(0,10));
//            }
//            dtoList.add(dto);
//        }
//        new LmsQcSubPlanExportHandler(dtoList).generater(response);
    }

}
