package com.patzn.lims.frame.controller;

import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Login;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.common.UploadUtils;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsYearPlanAttachment;
import com.patzn.lims.frame.service.ILmsYearPlanAttachmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import java.util.Iterator;
import java.util.List;

/**
 * <p>
 * 年度计划主表附件表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-07-25
 */
@Api(description = "年度计划主表附件表")
@RestController
@RequestMapping("/v1/year_plan_attachment")
public class LmsYearPlanAttachmentController extends ServiceController<ILmsYearPlanAttachmentService,LmsYearPlanAttachment> {

    @Autowired
    private ILmsYearPlanAttachmentService lmsYearPlanAttachmentService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<LmsYearPlanAttachment>> getPage(LmsYearPlanAttachment lmsYearPlanAttachment) {
        return success(lmsYearPlanAttachmentService.page(getPage(), lmsYearPlanAttachment));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsYearPlanAttachment>> getList(LmsYearPlanAttachment lmsYearPlanAttachment) {
        return success(lmsYearPlanAttachmentService.list(lmsYearPlanAttachment));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    @Override
    public PtResult<LmsYearPlanAttachment> get(@PathVariable("id") Long id) {
        return success(lmsYearPlanAttachmentService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsYearPlanAttachment lmsYearPlanAttachment) {
        lmsYearPlanAttachment.setId(id);
        return success(lmsYearPlanAttachmentService.updateById(lmsYearPlanAttachment));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
    public PtResult<Boolean> add(LmsYearPlanAttachment lmsYearPlanAttachment) {
        return success(lmsYearPlanAttachmentService.save(lmsYearPlanAttachment));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsYearPlanAttachmentService.remove(Wrappers.<LmsYearPlanAttachment>query().in("id", ids)));
    }


    @ApiOperation(value = "上传计划附件", notes = "上传计划附件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "planId", value = "计划 ID", required = true, paramType = "path", dataType = "long"),
    })
    @PostMapping("/{planId}")
    public PtResult<Boolean> uploadAttachment(@PathVariable("planId") Long planId, MultipartHttpServletRequest mhsr) {
        if (UploadUtils.resumeUpload(request)) {
            return null;
        }

        Iterator<String> fns = mhsr.getFileNames();
        while (fns.hasNext()) {
            // 获取上传的文件列表
            return success(lmsYearPlanAttachmentService.save(planId, mhsr.getFile(fns.next())));
        }
        return success(false);
    }


    @ApiOperation(value = "下载计划附件文件", notes = "根据 id 下载计划附件文件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @Login(action = Action.Skip)
    @GetMapping("/download/{id}")
    public void download(@PathVariable("id") Long id) {
        lmsYearPlanAttachmentService.download(id, response);
    }

}
