package com.patzn.lims.frame.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsYearPlan;
import com.patzn.lims.frame.entity.LmsYearPlanFile;
import com.patzn.lims.frame.enums.PlanStatusEnum;
import com.patzn.lims.frame.service.ILmsYearPlanService;
import com.patzn.lims.frame.vo.LmsYearPlanVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 年度总计划表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-06-26
 */
@Api(description = "年度总计划表")
@RestController
@RequestMapping("/v1/year_plan")
public class LmsYearPlanController extends ServiceController<ILmsYearPlanService,LmsYearPlan> {

    @Autowired
    private ILmsYearPlanService lmsYearPlanService;

    @ApiOperation(value = "评定计划分页列表", notes = "评定计划分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_plan")
    public PtResult<Page<LmsYearPlan>> getPage(LmsYearPlan lmsYearPlan, Date startDate, Date endDate) {
        return success(lmsYearPlanService.page(getPage(), lmsYearPlan, startDate, endDate));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsYearPlan>> getList(LmsYearPlan lmsYearPlan) {
        return success(lmsYearPlanService.list(lmsYearPlan));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")
    public PtResult<LmsYearPlanVO> getVO(@PathVariable("id") Long id) {
        return success(lmsYearPlanService.getVOById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsYearPlan lmsYearPlan) {
        lmsYearPlan.setId(id);
        return success(lmsYearPlanService.updatePlanById(lmsYearPlan));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
    public PtResult<Boolean> add(LmsYearPlan lmsYearPlan) {
        lmsYearPlan.setStatus((Integer) PlanStatusEnum.DRAFT.getValue());
        lmsYearPlan.setMakerId(LoginHelper.getAccount().getUserId());
        lmsYearPlan.setMaker(LoginHelper.getAccount().getUserName());
        lmsYearPlan.setMakeDate(new Date());
        lmsYearPlan.setTempStatus(1);
        return success(lmsYearPlanService.add(lmsYearPlan));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsYearPlanService.remove(Wrappers.<LmsYearPlan>query().in("id", ids)));
    }


    @ApiOperation(value = "复制年度总计划", notes = "复制年度总计划")
    @PostMapping("/copy")
    public PtResult<Boolean> copy(LmsYearPlan lmsYearPlan) {
        return success(lmsYearPlanService.copy(lmsYearPlan, getAccount()));
    }


    @ApiOperation(value = "评定报告分页列表", notes = "评定报告分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_report")
    public PtResult<Page<LmsYearPlan>> getPageReport(LmsYearPlan lmsYearPlan) {
        return success(lmsYearPlanService.pageReport(getPage(), lmsYearPlan));
    }


    @ApiOperation(value = "年度总计划批量提交", notes = "年度总计划批量提交")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键 ID 集合", required = true, paramType = "query", dataType = "array"),
    })
    @PostMapping("/submit_batch")
    public PtResult<Boolean> submitBatch(Long[] ids) {
        return success(null != lmsYearPlanService.submitYearPlanFlow(ids));
    }

    @ApiOperation(value = "年度总计划审批通过驳回按钮", notes = "年度总计划审批通过驳回按钮")
    @PostMapping("/approve/{taskId}")
    public PtResult<Boolean> approve(@PathVariable("taskId") String taskId, String status, String reason) {
        return success(lmsYearPlanService.approveFlow(taskId, status, reason));
    }

    @ApiOperation(value = "年度总计划审批信息确认按钮", notes = "年度总计划审批信息确认按钮")
    @PostMapping("/approveConfirm/{taskId}")
    public PtResult<Boolean> approveConfirm(@PathVariable("taskId") String taskId, String status, String reason) {
        return success(lmsYearPlanService.approveConfirm(taskId, status, reason));
    }


    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsYearPlanFile> uploadFile(@RequestParam("file") MultipartFile file, LmsYearPlan lmsYearPlan) {
        return success(lmsYearPlanService.uploadFile(file, lmsYearPlan));
    }

    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile/")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id) {
        return success(lmsYearPlanService.deleteFile(id));
    }

    @GetMapping("/getTemp/")
    public PtResult<LmsYearPlanVO> getTemp() {
        return success(lmsYearPlanService.getTempVO());
    }
}
