package com.patzn.lims.frame.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.frame.entity.LmsYearPlanRecord;
import com.patzn.lims.frame.service.ILmsYearPlanRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 年度不确定度计划主表操作记录表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-07-25
 */
@Api(description = "年度不确定度计划主表操作记录表")
@RestController
@RequestMapping("/v1/year_plan_record")
public class LmsYearPlanRecordController extends ServiceController<ILmsYearPlanRecordService,LmsYearPlanRecord> {

    @Autowired
    private ILmsYearPlanRecordService lmsYearPlanRecordService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<LmsYearPlanRecord>> getPage(LmsYearPlanRecord lmsYearPlanRecord) {
        return success(lmsYearPlanRecordService.page(getPage(), lmsYearPlanRecord));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsYearPlanRecord>> getList(LmsYearPlanRecord lmsYearPlanRecord) {
        return success(lmsYearPlanRecordService.list(lmsYearPlanRecord));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    @Override
    public PtResult<LmsYearPlanRecord> get(@PathVariable("id") Long id) {
        return success(lmsYearPlanRecordService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsYearPlanRecord lmsYearPlanRecord) {
        lmsYearPlanRecord.setId(id);
        return success(lmsYearPlanRecordService.updateById(lmsYearPlanRecord));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
    public PtResult<Boolean> add(LmsYearPlanRecord lmsYearPlanRecord) {
        return success(lmsYearPlanRecordService.save(lmsYearPlanRecord));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsYearPlanRecordService.remove(Wrappers.<LmsYearPlanRecord>query().in("id", ids)));
    }

}
