package com.patzn.lims.frame.entity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.frame.enums.PlanStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 能力验证计划子表
 * </p>
 *
 * @author patzn
 * @since 2018-07-19
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsAbilitySubPlan extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "状态")
	private Integer status;

	@ApiModelProperty(value = "进度")
	private Integer progress;

    @ApiModelProperty(value = "主计划ID")
	private Long mainPlanId;

    @ApiModelProperty(value = "项目名称及参数")
	private String name;

    @ApiModelProperty(value = "频次")
	private Integer frequency;

    @ApiModelProperty(value = "计划开始日期")
	private Date beginDate;

    @ApiModelProperty(value = "计划完成日期")
	private Date endDate;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "创建人ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "最后修改人ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

    @ApiModelProperty(value = "企业ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "是否删除")
    @TableLogic
	private Integer deleted;

    @ApiModelProperty(value = "子领域")
	private String subfield;

    @ApiModelProperty(value = "检测方法")
	private String method;

    @ApiModelProperty(value = "检测室")
	private String testRoom;

    @ApiModelProperty(value = "检测人")
	private String tester;

    @ApiModelProperty(value = "监控结果")
	private String monitorResult;

    @ApiModelProperty(value = "创建人")
	private String uname;

	@ApiModelProperty(value = "人员/部门")
	private String department;


	@ApiModelProperty(value = "实施人员")
	private String implementer;

	@ApiModelProperty(value = "完成时间")
	private Date completion;


}
