package com.patzn.lims.frame.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.frame.enums.ManageCheckEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 管理评审计划
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsFrameCheckPlan extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "状态")
	private Integer status;

	@ApiModelProperty(value = "进度")
	private Integer progress;

    @ApiModelProperty(value = "评审目的")
	@TableField(condition = SqlCondition.LIKE)
	private String checkPlanPurpose;

    @ApiModelProperty(value = "评审时间")
	private Date checkPlanTime;

    @ApiModelProperty(value = "评审地点")
	private String checkPlanPlace;

    @ApiModelProperty(value = "评审依据")
	@TableField(condition = SqlCondition.LIKE)
	private String checkPlanBasis;

    @ApiModelProperty(value = "评审组长id")
	private Long checkGroupLeaderId;

    @ApiModelProperty(value = "评审组长名")
	private String checkGroupLeaderName;

    @ApiModelProperty(value = "评审组成员ids")
	private String checkGroupMemberIds;

    @ApiModelProperty(value = "评审组成员名")
	private String checkGroupMemberNames;

    @ApiModelProperty(value = "评审日程安排及评审内容")
	private String checkPlanContent;

	@ApiModelProperty(value = "评审日程安排及评审内容纯文本")
	private String checkPlanContentText;

    @ApiModelProperty(value = "申请人id")
	private Long applyId;

    @ApiModelProperty(value = "申请人名")
	private String applyName;

    @ApiModelProperty(value = "申请时间")
	private Date applyTime;

    @ApiModelProperty(value = "批准人id")
	private Long auditId;

    @ApiModelProperty(value = "批准人名")
	private String auditName;

    @ApiModelProperty(value = "批准时间")
	private Date auditTime;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

	@ApiModelProperty(value = "用户id")
	private Long userId;

	@ApiModelProperty(value = "临时状态0临时数据，1正常数据")
	private Integer tempStatus;

	@ApiModelProperty(value = "是否删除0否1是")
	@TableLogic
	private Integer deleted;

	@ApiModelProperty(value = "创建人id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

	@ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

	@ApiModelProperty(value = "最后修改人id")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

	@ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

	@ApiModelProperty(value = "创建人")
	private String uname;

	@ApiModelProperty(value = "评审意见")
	private String approvalOpinion;

	@ApiModelProperty(value = "编制人")
	private String compactor;


	@ApiModelProperty(value = "编制人id")
	private Long compactorId;


	@ApiModelProperty(value = "编制时间")
	private Date compactTime;

}
