package com.patzn.lims.frame.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 管理评审报告表
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsFrameCheckReport extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "状态0草稿，1已提交")
    private Integer status;

    @ApiModelProperty(value = "评审计划id")
    private Long checkPlanId;

    @ApiModelProperty(value = "评审报告名称")
    @TableField(condition = SqlCondition.LIKE)
    private String checkReportName;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "公司id")
    @TableField(fill = FieldFill.INSERT)
    private Long companyId;

    @ApiModelProperty(value = "用户id")
    private Long userId;

    @ApiModelProperty(value = "用户姓名")
    private String userName;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "临时状态0临时数据1正常数据")
    private Integer tempStatus;


    @ApiModelProperty(value = "操作人 ID")
    @TableField(fill = FieldFill.INSERT)
    private Long uid;

    @ApiModelProperty(value = "操作人")
    @TableField(fill = FieldFill.INSERT)
    private String operator;

    @ApiModelProperty(value = "修改人 ID")
    @TableField(fill = FieldFill.UPDATE)
    private Long lid;

    @ApiModelProperty(value = "修改时间")
    @TableField(fill = FieldFill.UPDATE)
    private Date ltime;

    @ApiModelProperty(value = "创建时间")
    @TableField(fill = FieldFill.INSERT)
    private Date ctime;
}
