package com.patzn.lims.frame.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.frame.enums.ComplaintRegisterEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 投/申诉登记
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsFrameComplaintRegister extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "状态0草稿，1已提交")
	private ComplaintRegisterEnum status;

    @ApiModelProperty(value = "投/申诉单位")
	private String complaintUnit;

    @ApiModelProperty(value = "投/申诉时间")
	private Date complaintTime;

    @ApiModelProperty(value = "投/申诉人姓名")
	private String complaintName;

    @ApiModelProperty(value = "联系方式")
	private String complaintTel;

    @ApiModelProperty(value = "送检日期")
	private Date checkTime;

    @ApiModelProperty(value = "报告编号")
	private String reportNum;

    @ApiModelProperty(value = "投/申诉方式")
	private String complaintType;

    @ApiModelProperty(value = "投/申诉内容")
	private String complaintContent;

	@ApiModelProperty(value = "投/申诉内容纯文本")
	private String complaintContentText;

    @ApiModelProperty(value = "接受人id")
	private Long receiverId;

    @ApiModelProperty(value = "接受人姓名")
	private String receiverName;

    @ApiModelProperty(value = "接受日期")
	private Date receiverTime;

    @ApiModelProperty(value = "处理人id")
	private Long dealId;

    @ApiModelProperty(value = "处理人姓名")
	private String dealName;

    @ApiModelProperty(value = "处理意见")
	private String dealAdvice;

	@ApiModelProperty(value = "处理意见纯文本")
	private String dealAdviceText;

    @ApiModelProperty(value = "批准日期")
	private Date dealTime;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

	@ApiModelProperty(value = "用户id")
	private Long userId;

	@ApiModelProperty(value = "临时状态0临时数据，1正常数据")
	private Integer tempStatus;


}
