package com.patzn.lims.frame.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 客户满意度管理
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsFrameCustomerInvestigate extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "状态0草稿，1已提交")
	private Integer status;

    @ApiModelProperty(value = "客户名称")
	private String customerName;

    @ApiModelProperty(value = "客户地址")
	private String customerAddress;

    @ApiModelProperty(value = "联系人")
	private String customerContact;

    @ApiModelProperty(value = "电话")
	private String customerTel;

    @ApiModelProperty(value = "服务项目")
	private String serviceItems;

    @ApiModelProperty(value = "填表日期")
	private Date registerTime;

    @ApiModelProperty(value = "客户满意度结论")
	private String customerResult;

	@ApiModelProperty(value = "客户满意度结论纯文本")
	private String customerResultText;

    @ApiModelProperty(value = "其他意见和建议")
	private String customerAdvice;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

	@ApiModelProperty(value = "用户id")
	private Long userId;

	@ApiModelProperty(value = "临时状态0临时数据，1正常数据")
	private Integer tempStatus;


	@ApiModelProperty(value = "是否删除0否1是")
	@TableLogic
	private Integer deleted;

	@ApiModelProperty(value = "创建人id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

	@ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

	@ApiModelProperty(value = "最后修改人id")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

	@ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

	@ApiModelProperty(value = "创建人")
	private String uname;
}
