package com.patzn.lims.frame.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 内审计划操作记录表
 * </p>
 *
 * @author patzn
 * @since 2018-07-19
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsFrameCustomerInvestigateDetailRecord extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "公司 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "满意调查项目 ID")
	private Long investigateDetailId;

    @ApiModelProperty(value = "类型 0、流转 1、回退 2、更新")
	private Integer type;

    @ApiModelProperty(value = "操作阶段")
	private String origin;

    @ApiModelProperty(value = "目标阶段")
	private String target;

    @ApiModelProperty(value = "责任人")
	private String liable;

    @ApiModelProperty(value = "操作人")
	private String operator;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "操作人 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "操作时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;


}
