package com.patzn.lims.frame.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 内审实施管理
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsFrameInnerCheckManage extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "状态0草稿，1已提交")
	private Integer status;

    @ApiModelProperty(value = "内审计划id")
	private Long checkPlanId;

    @ApiModelProperty(value = "内审员id")
	private Long checkMemberId;

    @ApiModelProperty(value = "内审员名")
	private String checkMemberName;

    @ApiModelProperty(value = "内审结束日期")
	private Date checkManageTime;

    @ApiModelProperty(value = "对应的质量管理体系文件名称及章节/条款号")
	private String checkManageItem;

    @ApiModelProperty(value = "检查内容")
	private String checkManageContent;

    @ApiModelProperty(value = "检查结果")
	private String checkManageResult;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

	@ApiModelProperty(value = "用户id")
    private Long userId;

	@ApiModelProperty(value = "临时状态0临时数据，1正常数据")
    private Integer tempStatus;

	@ApiModelProperty(value = "是否删除0否1是")
	@TableLogic
	private Integer deleted;

	@ApiModelProperty(value = "创建人id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

	@ApiModelProperty(value = "登记人姓名")
	private String uname;

	@ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

	@ApiModelProperty(value = "最后修改人id")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

	@ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

	@ApiModelProperty(value = "检查类别")
	private String checkType;

}
