package com.patzn.lims.frame.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.frame.enums.LmsInnerStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsFrameInnerCheckPlan extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "状态")
	private Integer status;

	@ApiModelProperty(value = "进度")
	private Integer progress;

    @ApiModelProperty(value = "审核目的")
	private String checkPlanPurpose;

    @ApiModelProperty(value = "审核时间")
	private Date checkPlanTime;

    @ApiModelProperty(value = "审核依据")
	private String checkPlanBasis;

    @ApiModelProperty(value = "审核方法")
	private String checkPlanMethod;

    @ApiModelProperty(value = "审核类型")
	private String checkPlanType;

    @ApiModelProperty(value = "审核范围")
	private String checkPlanRange;

    @ApiModelProperty(value = "审核组长id")
	private Long checkGroupLeaderId;

    @ApiModelProperty(value = "审核组长名")
	private String checkGroupLeaderName;

    @ApiModelProperty(value = "审核组成员id")
	private String checkGroupMemberIds;

    @ApiModelProperty(value = "审核组成员名")
	private String checkGroupMemberNames;

    @ApiModelProperty(value = "审核内容")
	private String checkPlanContent;

	@ApiModelProperty(value = "审核内容纯文本")
	private String checkPlanContentText;

    @ApiModelProperty(value = "申请人id")
	private Long applyId;

    @ApiModelProperty(value = "申请人名")
	private String applyName;

    @ApiModelProperty(value = "申请日期")
	private Date applyTime;

    @ApiModelProperty(value = "批准人id")
	private Long auditId;

    @ApiModelProperty(value = "批准人名")
	private String auditName;

    @ApiModelProperty(value = "批准日期")
	private Date auditTime;

    @ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "审批意见")
	private String approvalOpinion;

    @ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

	@ApiModelProperty(value = "用户id")
	private Long userId;

	@ApiModelProperty(value = "临时状态0临时数据，1正常数据")
	private Integer tempStatus;


	@ApiModelProperty(value = "是否删除0否1是")
	@TableLogic
	private Integer deleted;

	@ApiModelProperty(value = "创建人id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

	@ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

	@ApiModelProperty(value = "最后修改人id")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

	@ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;



}
