package com.patzn.lims.frame.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 体系管理操作日志表
 * </p>
 *
 * @author patzn123
 * @since 2018-01-11
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsFrameLog extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "用户id")
	private Long userId;

    @ApiModelProperty(value = "用户姓名")
	private String userName;

    @ApiModelProperty(value = "表名")
	private String tableName;

    @ApiModelProperty(value = "原始数据")
	private String orginParams;

    @ApiModelProperty(value = "操作参数")
	private String params;

    @ApiModelProperty(value = "创建时间")
	private Date createTime;

    @ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;


}
