package com.patzn.lims.frame.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.frame.enums.ProblemImproveEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 改进/纠正/预防措施管理
 * </p>
 *
 * @author patzn
 * @since 2018-07-18
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsFrameProblemImprove extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "问题")
	private String problem;

	@ApiModelProperty(value = "问题展示")
	private String problemDisplay;

    @ApiModelProperty(value = "纠正/预防措施")
	private String measures;

	@ApiModelProperty(value = "纠正/预防措施展示")
	private String measuresDisplay;

    @ApiModelProperty(value = "截止日期")
	private Date closingDate;

    @ApiModelProperty(value = "编制人")
	private String compactor;

    @ApiModelProperty(value = "编制人id")
	private Long compactorId;

    @ApiModelProperty(value = "编制人日期")
	private Date compilateDate;

    @ApiModelProperty(value = "负责人")
	private String charger;

    @ApiModelProperty(value = "负责人id")
	private Long chargerId;

    @ApiModelProperty(value = "检查人")
	private String checker;

    @ApiModelProperty(value = "检查人id")
	private Long checkerId;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "企业id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "是否删除0否1是")
    @TableLogic
	private Integer deleted;

    @ApiModelProperty(value = "创建人id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "最后修改人id")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

    @ApiModelProperty(value = "状态")
	private ProblemImproveEnum status;

	@ApiModelProperty(value = "数据状态")
	private Integer tempStatus;


}
