package com.patzn.lims.frame.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.frame.enums.UnconformRegisterEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 不符合项登记
 * </p>
 *
 * @author patzn123
 * @since 2018-01-10
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsFrameUnconformRegister extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "状态0草稿，1部门负责人一次审批，2部门负责人一次审批通过，3质量负责人一次审批通过，4部门负责人二次审批通过，5质量负责人二次审批通过，6部门负责人一次审批驳回，7质量负责人一次审批驳回，8部门负责人二次审批驳回，9质量负责人二次审批驳回,10审批完成")
    private UnconformRegisterEnum status;

    @ApiModelProperty(value = "受审核部门id")
    private Long orgId;

    @ApiModelProperty(value = "受审核部门名称")
    private String orgName;

    @ApiModelProperty(value = "部门负责人id")
    private Long orgManagerId;

    @ApiModelProperty(value = "部门负责人姓名")
    private String orgManagerName;

    @ApiModelProperty(value = "不符合条款")
    private String unconformItem;

    @ApiModelProperty(value = "不符合条款纯文本")
    private String unconformItemText;

    @ApiModelProperty(value = "登记时间")
    private Date registerTime;

    @ApiModelProperty(value = "登记人id")
    private Long registerId;

    @ApiModelProperty(value = "登记人姓名")
    private String registerName;

    @ApiModelProperty(value = "不符合项原因分析")
    private String unconformReason;

    @ApiModelProperty(value = "不符合项原因分析纯文本")
    private String unconformReasonText;

    @ApiModelProperty(value = "部门负责人签字")
    private String orgManagerAudit;

    @ApiModelProperty(value = "部门负责人签字时间")
    private Date orgManagerTime;

    @ApiModelProperty(value = "建议的纠正措施计划")
    private String verifyPlan;

    @ApiModelProperty(value = "建议的纠正措施计划纯文本")
    private String verifyPlanText;

    @ApiModelProperty(value = "质量负责人签字")
    private String qualityManagerAudit;

    @ApiModelProperty(value = "质量负责人签字时间")
    private Date qualityManagerTime;

    @ApiModelProperty(value = "纠正措施完成情况")
    private String verifyFinish;

    @ApiModelProperty(value = "纠正措施完成情况纯文本")
    private String verifyFinishText;

    @ApiModelProperty(value = "部门负责人签字")
    private String orgManagerAudit2;

    @ApiModelProperty(value = "部门负责人签字时间")
    private Date orgManagerTime2;

    @ApiModelProperty(value = "纠正措施的验证")
    private String verifyCheck;

    @ApiModelProperty(value = "纠正措施的验证纯文本")
    private String verifyCheckText;

    @ApiModelProperty(value = "质量负责人签字")
    private String qualityManagerAudit2;

    @ApiModelProperty(value = "质量负责人签字时间")
    private Date qualityManagerTime2;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "公司id")
    @TableField(fill = FieldFill.INSERT)
    private Long companyId;

    @ApiModelProperty(value = "用户id")
    private Long userId;

    @ApiModelProperty(value = "临时状态0临时数据1正常数据")
    private Integer tempStatus;


}
