package com.patzn.lims.frame.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.frame.enums.PlanStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 内部质控计划主表
 * </p>
 *
 * @author patzn
 * @since 2018-07-09
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsQcMainPlan extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "状态（草稿、实施中、完成）")
	private Integer status;

	@ApiModelProperty(value = "进度")
	private Integer progress;

    @ApiModelProperty(value = "计划名称")
	private String name;

    @ApiModelProperty(value = "编制人ID")
	private Long makerId;

    @ApiModelProperty(value = "编制人")
	private String maker;

    @ApiModelProperty(value = "批准人ID")
	private Long approverId;

    @ApiModelProperty(value = "批准人")
	private String approver;

	@ApiModelProperty(value = "审批意见")
	private String approveOpinion;

    @ApiModelProperty(value = "编制日期")
	private Date makeDate;

    @ApiModelProperty(value = "批准日期")
	private Date approveDate;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "企业ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "创建人ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "最后修改人ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

    @ApiModelProperty(value = "是否删除：0 否、1 是")
    @TableLogic
	private Integer deleted;

	@ApiModelProperty(value = "临时状态")
	private Integer tempStatus;

}
