package com.patzn.lims.frame.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.JsonEnumDeserializer;
import java.io.Serializable;

/**
 * <p>
 * 投申诉 状态枚举类
 * <p>
 *
 * @author xutao
 * @date 2019/9/8
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum ComplaintRegisterEnum  {

    DRAFT(0, "草稿"),

    EXAMINE(10, "审批中"),

    EXAMINE_BACK(12, "审批驳回"),

    EXAMINE_PASS(1, "待实施"),
    ;
    private int value;
    private String display;

    ComplaintRegisterEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }

    public static ComplaintRegisterEnum valueOf(int value) {
        ComplaintRegisterEnum[] cse = ComplaintRegisterEnum.values();
        for (ComplaintRegisterEnum cs : cse) {
            if (cs.value == value) {
                return cs;
            }
        }
        return null;
    }

    public Serializable getValue() {
        return value;
    }

    public String getName() {
        return name();
    }

    public String getDisplay() {
        return display;
    }
}
