package com.patzn.lims.frame.enums;

/**
 * 仪器文件类型枚举类
 */
public enum FrameFileTypeEnum {
    INNER_CHECK_PLAN(0, "内审计划"),
    INNER_CHECK_MANAGE(1, "内审管理"),
    INNER_CHECK_REPORT(2, "内审报告"),
    CHECK_PLAN(3, "评审计划"),
    CHECK_MANAGE(4, "评审管理"),
    CHECK_REPORT(5, "评审报告"),
    CUSTOMER_INVEST(6, "客户满意度管理"),
    COMPLAINT_REGISTER(7, "投/申诉登记"),
    UN_CONFORM_REGISTER(8, "不符合项登记"),
    UN_CONFORM_IMPROVE(9, "不符合项改进"),
    PROBLEM_IMPROVE(10, "改进/纠正/预防措施管理");

    private int value;
    private String display;

    FrameFileTypeEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name();
    }

    public String getDisplay() {
        return display;
    }
}