package com.patzn.lims.frame.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 样品状态枚举
 * </p>
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum LmsInnerStatusEnum {

    DRAFT(0, "草稿"),

    EXAMINE(10, "审批中"),

    EXAMINE_BACK(12, "审批驳回"),

    EXAMINE_PASS(1, "待实施");

    private int value;
    private String display;

    LmsInnerStatusEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }

    public static LmsInnerStatusEnum valueOf(int value) {
        LmsInnerStatusEnum[] cse = LmsInnerStatusEnum.values();
        for (LmsInnerStatusEnum cs : cse) {
            if (cs.value == value) {
                return cs;
            }
        }
        return null;
    }

    public Serializable getValue() {
        return value;
    }

    public String getName() {
        return name();
    }

    public String getDisplay() {
        return display;
    }
}
