package com.patzn.lims.frame.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 样品状态枚举
 * </p>
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum ManageCheckEnum  {

    DRAFT(0, "草稿"),

    EXAMINE(10, "审批中"),

    EXAMINE_BACK(12, "审批驳回"),

    EXAMINE_PASS(1, "待实施"),
      ;
    private int value;
    private String display;

    ManageCheckEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }

    public static ManageCheckEnum valueOf(int value) {
        ManageCheckEnum[] cse = ManageCheckEnum.values();
        for (ManageCheckEnum cs : cse) {
            if (cs.value == value) {
                return cs;
            }
        }
        return null;
    }

    public Serializable getValue() {
        return value;
    }

    public String getName() {
        return name();
    }

    public String getDisplay() {
        return display;
    }
}
