package com.patzn.lims.frame.enums;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 年度计划状态枚举
 * </p>
 *
 * @author yuanchao
 * @since 2018-06-26
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum PlanStatusEnum {
    DRAFT(10, "草稿"),
    START(20, "实施中"),
    AUDIT(25, "待审批人审批"),
    PASS(26, "审批通过"),
    BACK(27, "审批驳回"),
    END(30, "完成");

    private int value;
    private String display;

    PlanStatusEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }
    public static PlanStatusEnum valueOf(int value) {
        PlanStatusEnum[] cse = PlanStatusEnum.values();
        for (PlanStatusEnum cs : cse) {
            if (cs.value == value) {
                return cs;
            }
        }
        return null;
    }

    public Serializable getValue() {
        return value;
    }

    public String getName() {
        return name();
    }

    public String getDisplay() {
        return display;
    }
}