package com.patzn.lims.frame.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 满意度枚举
 * </p>
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum SatisfactionEnum  {

    VERY_SATISFIED(0, "很满意"),

    SATISFIED(1, "满意"),

    MORE_SATISFIED(2, "较满意"),

    DISSATISFIED(3, "不满意"),

    VERY_DISSATISFIED(4, "很不满"),
      ;
    private int value;
    private String display;

    SatisfactionEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }

    public static SatisfactionEnum valueOf(int value) {
        SatisfactionEnum[] cse = SatisfactionEnum.values();
        for (SatisfactionEnum cs : cse) {
            if (cs.value == value) {
                return cs;
            }
        }
        return null;
    }

    public Serializable getValue() {
        return value;
    }

    public String getName() {
        return name();
    }

    public String getDisplay() {
        return display;
    }
}
