package com.patzn.lims.frame.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 满意度枚举
 * </p>
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum UnconformRegisterEnum  {
    DRAFT(0, "草稿"),

    DEPARTMENT_HEAD_ONE_CHECK(1, "部门负责人一次审批"),

    DEPARTMENT_HEAD_ONE_CHECK_PASS(2, "部门负责人一次审批通过"),

    QUALITY_HEAD_ONE_CHECK_PASS(3, "质量负责人一次审批通过"),

    DEPARTMENT_HEAD_TWO_CHECK_PASS(4, "部门负责人二次审批通过"),

    QUALITY_HEAD_TWO_CHECK_PASS(5, "质量负责人二次审批通过"),

    DEPARTMENT_HEAD_ONE_CHECK_BACK(6, "部门负责人一次审批驳回"),

    QUALITY_HEAD_ONE_CHECK_BACK(7, "质量负责人一次审批驳回"),

    DEPARTMENT_HEAD_TWO_CHECK_BACK(8, "部门负责人二次审批驳回"),

    QUALITY_HEAD_TWO_CHECK_BACK(9, "质量负责人二次审批驳回"),

    END(10, "审批完成"),
      ;
    private int value;
    private String display;
   UnconformRegisterEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }

    public static UnconformRegisterEnum valueOf(int value) {
        UnconformRegisterEnum[] cse = UnconformRegisterEnum.values();
        for (UnconformRegisterEnum cs : cse) {
            if (cs.value == value) {
                return cs;
            }
        }
        return null;
    }

    public Serializable getValue() {
        return value;
    }

    public String getName() {
        return name();
    }

    public String getDisplay() {
        return display;
    }
}
