package com.patzn.lims.frame.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.frame.entity.LmsAbilityMainPlan;
import com.patzn.lims.frame.entity.LmsAbilityMainPlanAttachment;
import com.patzn.lims.frame.vo.LmsAbilityMainPlanVO;
import com.patzn.lims.workflow.FlowProcess;
import org.springframework.web.multipart.MultipartFile;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 能力验证计划主表 服务类
 * </p>
 *
 * @author patzn
 * @since 2018-07-19
 */
public interface ILmsAbilityMainPlanService extends IBaseService<LmsAbilityMainPlan> {


    Page<LmsAbilityMainPlan> page(Page<LmsAbilityMainPlan> page, LmsAbilityMainPlan lmsAbilityMainPlan);


    List<LmsAbilityMainPlan> list(LmsAbilityMainPlan lmsAbilityMainPlan);


    Page<LmsAbilityMainPlan> pagePlan(Page<LmsAbilityMainPlan> page, LmsAbilityMainPlan lmsAbilityMainPlan, Date startDate, Date endDate);


    boolean copy(LmsAbilityMainPlan lmsAbilityMainPlan, Account account);


    boolean removeByIds(Long[] ids);


    boolean updatePlanById(LmsAbilityMainPlan lmsAbilityMainPlan);


    List<FlowProcess> submitCheckFlow(Long[] ids, Account account);


    boolean approveFlow(String taskId, String status, String reason);


    void exportPlan(HttpServletResponse response, Long id);

    LmsAbilityMainPlan getTempVO();

    LmsAbilityMainPlanAttachment uploadFile(MultipartFile file, LmsAbilityMainPlan lmsAbilityMainPlan);

    Boolean deleteFile(Long id);

    LmsAbilityMainPlanVO getVOById(Long id);

    Boolean add(LmsAbilityMainPlan lmsAbilityMainPlan);
}
